/*
 * Decompiled with CFR 0.152.
 */
package git4idea.jgit;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.AuthData;
import com.intellij.util.proxy.CommonProxy;
import git4idea.GitVcs;
import git4idea.jgit.GitHttpAuthDataProvider;
import git4idea.jgit.GitHttpCredentialsProvider;
import git4idea.jgit.GitHttpRemoteCommand;
import git4idea.push.GitSimplePushResult;
import git4idea.remote.GitRememberedInputs;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitHttpAdapter {
    private static final Logger LOG = Logger.getInstance(GitHttpAdapter.class);
    private static final String IGNORECASE_SETTING = "ignorecase";

    public static boolean shouldUseJGit(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "shouldUseJGit"));
        }
        return "jgit".equals(System.getProperty("git.http"));
    }

    private GitHttpAdapter() {
    }

    @NotNull
    public static GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @Nullable String remoteBranch) {
        GitFetchResult.Type resultType;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "fetch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "fetch"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpAdapter", "fetch"));
        }
        try {
            Git git = GitHttpAdapter.convertToGit(repository);
            GitHttpCredentialsProvider provider = new GitHttpCredentialsProvider(repository.getProject(), remoteUrl);
            List<String> specs = remoteBranch == null ? remote.getFetchRefSpecs() : Collections.singletonList(GitFetcher.getFetchSpecForBranch(remoteBranch, remote.getName()));
            GeneralResult result = GitHttpAdapter.callWithAuthRetry(new GitHttpRemoteCommand.Fetch(git, provider, remoteUrl, GitHttpAdapter.convertRefSpecs(specs)), repository.getProject());
            resultType = GitHttpAdapter.convertToFetchResultType(result);
        }
        catch (IOException e) {
            GitHttpAdapter.logException(repository, remote.getName(), remoteUrl, e, "fetching");
            GitFetchResult gitFetchResult = GitFetchResult.error(e);
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "fetch"));
            }
            return gitFetchResult;
        }
        catch (InvalidRemoteException e) {
            GitHttpAdapter.logException(repository, remote.getName(), remoteUrl, (Exception)((Object)e), "fetching");
            GitFetchResult gitFetchResult = GitFetchResult.error((Exception)((Object)e));
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "fetch"));
            }
            return gitFetchResult;
        }
        catch (URISyntaxException e) {
            GitHttpAdapter.logException(repository, remote.getName(), remoteUrl, e, "fetching");
            GitFetchResult gitFetchResult = GitFetchResult.error(e);
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "fetch"));
            }
            return gitFetchResult;
        }
        GitFetchResult gitFetchResult = new GitFetchResult(resultType);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "fetch"));
        }
        return gitFetchResult;
    }

    @NotNull
    private static List<RefSpec> convertRefSpecs(@NotNull List<String> refSpecs) {
        if (refSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "convertRefSpecs"));
        }
        ArrayList<RefSpec> jgitSpecs = new ArrayList<RefSpec>();
        for (String spec : refSpecs) {
            jgitSpecs.add(new RefSpec(spec));
        }
        ArrayList<RefSpec> arrayList = jgitSpecs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertRefSpecs"));
        }
        return arrayList;
    }

    private static void logException(GitRepository repository, String remoteName, String remoteUrl, Exception e, String operation) {
        LOG.error("Exception while " + operation + " " + remoteName + "(" + remoteUrl + ")" + " in " + repository.toLogString(), (Throwable)e);
    }

    private static GitFetchResult.Type convertToFetchResultType(GeneralResult result) {
        switch (result) {
            case CANCELLED: {
                return GitFetchResult.Type.CANCELLED;
            }
            case SUCCESS: {
                return GitFetchResult.Type.SUCCESS;
            }
            case NOT_AUTHORIZED: {
                return GitFetchResult.Type.NOT_AUTHORIZED;
            }
        }
        return GitFetchResult.Type.CANCELLED;
    }

    @NotNull
    public static GitSimplePushResult push(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String pushSpec) {
        GitSimplePushResult gitSimplePushResult;
        GitSimplePushResult pushResult;
        block16: {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            if (remoteName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            if (remoteUrl == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            if (pushSpec == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            Git git = GitHttpAdapter.convertToGit(repository);
            GitHttpCredentialsProvider provider = new GitHttpCredentialsProvider(repository.getProject(), remoteUrl);
            GitHttpRemoteCommand.Push pushCommand = new GitHttpRemoteCommand.Push(git, provider, remoteName, remoteUrl, GitHttpAdapter.convertRefSpecs(Collections.singletonList(pushSpec)));
            GeneralResult result = GitHttpAdapter.callWithAuthRetry(pushCommand, repository.getProject());
            pushResult = pushCommand.getResult();
            if (pushResult != null) break block16;
            GitSimplePushResult gitSimplePushResult2 = GitHttpAdapter.convertToPushResultType(result);
            if (gitSimplePushResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            return gitSimplePushResult2;
        }
        try {
            gitSimplePushResult = pushResult;
        }
        catch (SmartPushNotSupportedException e) {
            GitSimplePushResult gitSimplePushResult3 = GitSimplePushResult.error("Remote <code>" + remoteUrl + "</code> doesn't support <a href=\"http://progit.org/2010/03/04/smart-http.html\">" + "smart HTTP push. </a><br/>" + "Please set the server to use smart push or use other protocol (SSH for example). <br/>" + "If neither is possible, as a workaround you may add authentication data directly to the remote url in <code>.git/config</code>.");
            if (gitSimplePushResult3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            return gitSimplePushResult3;
        }
        catch (InvalidRemoteException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, (Exception)((Object)e), "pushing");
            GitSimplePushResult gitSimplePushResult4 = GitHttpAdapter.makeErrorResultFromException((Exception)((Object)e));
            if (gitSimplePushResult4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            return gitSimplePushResult4;
        }
        catch (IOException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, e, "pushing");
            GitSimplePushResult gitSimplePushResult5 = GitHttpAdapter.makeErrorResultFromException(e);
            if (gitSimplePushResult5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            return gitSimplePushResult5;
        }
        catch (URISyntaxException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, e, "pushing");
            GitSimplePushResult gitSimplePushResult6 = GitHttpAdapter.makeErrorResultFromException(e);
            if (gitSimplePushResult6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
            }
            return gitSimplePushResult6;
        }
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "push"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static Collection<String> lsRemote(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String remoteUrl) {
        Collection<String> collection;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "lsRemote"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "lsRemote"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpAdapter", "lsRemote"));
        }
        try {
            Git git = GitHttpAdapter.convertToGit(repository);
            GitHttpCredentialsProvider provider = new GitHttpCredentialsProvider(repository.getProject(), remoteUrl);
            GitHttpRemoteCommand.LsRemote lsRemoteCommand = new GitHttpRemoteCommand.LsRemote(git, provider, remoteUrl);
            GitHttpAdapter.callWithAuthRetry(lsRemoteCommand, repository.getProject());
            collection = GitHttpAdapter.convertRefsToStrings(lsRemoteCommand.getRefs());
        }
        catch (IOException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, e, "ls-remote");
        }
        catch (InvalidRemoteException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, (Exception)((Object)e), "ls-remote");
        }
        catch (URISyntaxException e) {
            GitHttpAdapter.logException(repository, remoteName, remoteUrl, e, "ls-remote");
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "lsRemote"));
        }
        return collection;
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "lsRemote"));
        }
        return list;
    }

    @NotNull
    private static Collection<String> convertRefsToStrings(@NotNull Collection<Ref> lsRemoteCommandRefs) {
        if (lsRemoteCommandRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "convertRefsToStrings"));
        }
        ArrayList<String> refs = new ArrayList<String>();
        for (Ref ref : lsRemoteCommandRefs) {
            String refName = ref.getName();
            if (refName.startsWith("refs/heads/")) {
                refName = refName.substring("refs/heads/".length());
            }
            refs.add(refName);
        }
        ArrayList<String> arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertRefsToStrings"));
        }
        return arrayList;
    }

    @NotNull
    public static GitFetchResult cloneRepository(@NotNull Project project, @NotNull File directory, @NotNull String url) {
        GitFetchResult gitFetchResult;
        block11: {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
            }
            try {
                GitHttpCredentialsProvider provider = new GitHttpCredentialsProvider(project, url);
                GitHttpRemoteCommand.Clone command = new GitHttpRemoteCommand.Clone(directory, provider, url);
                GeneralResult result = GitHttpAdapter.callWithAuthRetry(command, project);
                GitFetchResult.Type resultType = GitHttpAdapter.convertToFetchResultType(result);
                if (resultType.equals((Object)GitFetchResult.Type.SUCCESS)) {
                    GitHttpAdapter.updateCoreIgnoreCaseSetting(command.getGit());
                }
                if ((gitFetchResult = new GitFetchResult(resultType)) != null) break block11;
            }
            catch (InvalidRemoteException e) {
                LOG.info("Exception while cloning " + url + " to " + directory, (Throwable)e);
                GitFetchResult gitFetchResult2 = GitFetchResult.error((Exception)((Object)e));
                if (gitFetchResult2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
                }
                return gitFetchResult2;
            }
            catch (IOException e) {
                LOG.info("Exception while cloning " + url + " to " + directory, (Throwable)e);
                GitFetchResult gitFetchResult3 = GitFetchResult.error(e);
                if (gitFetchResult3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
                }
                return gitFetchResult3;
            }
            catch (URISyntaxException e) {
                LOG.info("Exception while cloning " + url + " to " + directory, (Throwable)e);
                GitFetchResult gitFetchResult4 = GitFetchResult.error(e);
                if (gitFetchResult4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
                }
                return gitFetchResult4;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "cloneRepository"));
        }
        return gitFetchResult;
    }

    private static void updateCoreIgnoreCaseSetting(@Nullable Git git) {
        if (SystemInfo.isFileSystemCaseSensitive) {
            return;
        }
        if (git == null) {
            LOG.info("jgit.Git is null, the command should have failed. Not updating the settings.");
            return;
        }
        StoredConfig config = git.getRepository().getConfig();
        config.setString("core", null, IGNORECASE_SETTING, Boolean.TRUE.toString());
        try {
            config.save();
        }
        catch (IOException e) {
            LOG.info("Couldn't save config for " + git.getRepository().getDirectory().getPath(), (Throwable)e);
        }
    }

    @NotNull
    private static GitSimplePushResult convertToPushResultType(GeneralResult result) {
        switch (result) {
            case SUCCESS: {
                GitSimplePushResult gitSimplePushResult = GitSimplePushResult.success();
                if (gitSimplePushResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertToPushResultType"));
                }
                return gitSimplePushResult;
            }
            case CANCELLED: {
                GitSimplePushResult gitSimplePushResult = GitSimplePushResult.cancel();
                if (gitSimplePushResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertToPushResultType"));
                }
                return gitSimplePushResult;
            }
            case NOT_AUTHORIZED: {
                GitSimplePushResult gitSimplePushResult = GitSimplePushResult.notAuthorized();
                if (gitSimplePushResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertToPushResultType"));
                }
                return gitSimplePushResult;
            }
        }
        GitSimplePushResult gitSimplePushResult = GitSimplePushResult.cancel();
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convertToPushResultType"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    private static GitSimplePushResult makeErrorResultFromException(Exception e) {
        GitSimplePushResult gitSimplePushResult = GitSimplePushResult.error(e.toString());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "makeErrorResultFromException"));
        }
        return gitSimplePushResult;
    }

    /*
     * Exception decompiling
     */
    private static GeneralResult callWithAuthRetry(@NotNull GitHttpRemoteCommand command, @NotNull Project project) throws InvalidRemoteException, IOException, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CommonProxy.HostInfo getHostInfo(String url) throws URISyntaxException {
        boolean isSecure = url.startsWith("https");
        String protocol = isSecure ? "https" : "http";
        URI uri = new URI(url);
        int port = uri.getPort();
        port = port < 0 ? (isSecure ? 443 : 80) : port;
        return new CommonProxy.HostInfo(protocol, uri.getHost(), port);
    }

    @NotNull
    private static String addDotGitToUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "addDotGitToUrl"));
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String string = url + ".git";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "addDotGitToUrl"));
        }
        return string;
    }

    private static void log(@NotNull GitHttpRemoteCommand command, @NotNull Project project) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "log"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "log"));
        }
        GitVcs vcs = GitVcs.getInstance(project);
        if (vcs != null) {
            vcs.showCommandLine(command.getCommandString());
        }
        LOG.info(command.getLogString());
    }

    private static boolean smartHttpPushNotSupported(JGitInternalException e) {
        if (e.getCause() instanceof NotSupportedException) {
            NotSupportedException nse = (NotSupportedException)e.getCause();
            String message = nse.getMessage();
            return message != null && message.toLowerCase().contains("smart http push");
        }
        return false;
    }

    private static boolean isNoRemoteWithoutDotGitError(Throwable e, String url) {
        Throwable cause = e.getCause();
        if (cause == null || !(cause instanceof NoRemoteRepositoryException) && !(cause.getCause() instanceof NoRemoteRepositoryException)) {
            return false;
        }
        return !url.toLowerCase().endsWith(".git");
    }

    private static boolean isTransportExceptionForHttp(@NotNull JGitInternalException e, @NotNull String url) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "isTransportExceptionForHttp"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "isTransportExceptionForHttp"));
        }
        if (!(e.getCause() instanceof TransportException)) {
            return false;
        }
        return url.toLowerCase().startsWith("http") && !url.toLowerCase().startsWith("https");
    }

    private static void rememberPassword(@NotNull GitHttpCredentialsProvider credentialsProvider) {
        if (credentialsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "rememberPassword"));
        }
        if (!credentialsProvider.wasDialogShown()) {
            return;
        }
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        if (passwordSafe.getSettings().getProviderType() == PasswordSafeSettings.ProviderType.DO_NOT_STORE) {
            return;
        }
        String login = credentialsProvider.getUserName();
        if (login == null || credentialsProvider.getPassword() == null) {
            return;
        }
        String url = GitHttpAdapter.adjustHttpUrl(credentialsProvider.getUrl());
        String key = GitHttpAdapter.keyForUrlAndLogin(url, login);
        try {
            GitHttpAdapter.storePassword((PasswordSafeProvider)passwordSafe.getMemoryProvider(), credentialsProvider, key);
            if (credentialsProvider.isRememberPassword()) {
                GitHttpAdapter.storePassword((PasswordSafeProvider)passwordSafe.getMasterKeyProvider(), credentialsProvider, key);
            }
            GitRememberedInputs.getInstance().addUrl(url, login);
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't store the password for key [" + key + "]", (Throwable)e);
        }
    }

    private static void storePassword(PasswordSafeProvider passwordProvider, GitHttpCredentialsProvider credentialsProvider, String key) throws PasswordSafeException {
        passwordProvider.storePassword(credentialsProvider.getProject(), GitHttpCredentialsProvider.class, key, credentialsProvider.getPassword());
    }

    @Nullable
    private static AuthData getUsernameAndPassword(Project project, String url) {
        url = GitHttpAdapter.adjustHttpUrl(url);
        String userName = GitRememberedInputs.getInstance().getUserNameForUrl(url);
        if (userName == null) {
            return GitHttpAdapter.trySavedAuthDataFromProviders(url);
        }
        String key = GitHttpAdapter.keyForUrlAndLogin(url, userName);
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        try {
            String password = passwordSafe.getPassword(project, GitHttpCredentialsProvider.class, key);
            if (password != null) {
                return new AuthData(userName, password);
            }
            return null;
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't get the password for key [" + key + "]", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static AuthData trySavedAuthDataFromProviders(@NotNull String url) {
        GitHttpAuthDataProvider[] extensions;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "trySavedAuthDataFromProviders"));
        }
        for (GitHttpAuthDataProvider provider : extensions = (GitHttpAuthDataProvider[])GitHttpAuthDataProvider.EP_NAME.getExtensions()) {
            AuthData authData = provider.getAuthData(url);
            if (authData == null) continue;
            return authData;
        }
        return null;
    }

    @NotNull
    private static String adjustHttpUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "adjustHttpUrl"));
        }
        if (url.startsWith("https")) {
            String string = url.replaceFirst("https", "http");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "adjustHttpUrl"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "adjustHttpUrl"));
        }
        return string;
    }

    @NotNull
    private static String keyForUrlAndLogin(@NotNull String stringUrl, @NotNull String login) {
        if (stringUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "keyForUrlAndLogin"));
        }
        if (login == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpAdapter", "keyForUrlAndLogin"));
        }
        String string = login + ":" + stringUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "keyForUrlAndLogin"));
        }
        return string;
    }

    private static boolean authError(@NotNull JGitInternalException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "authError"));
        }
        Throwable cause = e.getCause();
        return cause instanceof TransportException && cause.getMessage().contains("not authorized");
    }

    @NotNull
    private static Repository convert(@NotNull GitRepository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "convert"));
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        FileRepository fileRepository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(repository.getRoot().getPath(), ".git"))).readEnvironment()).findGitDir()).build();
        if (fileRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpAdapter", "convert"));
        }
        return fileRepository;
    }

    private static Git convertToGit(@NotNull GitRepository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpAdapter", "convertToGit"));
        }
        return Git.wrap((Repository)GitHttpAdapter.convert(repository));
    }

    private static class SmartPushNotSupportedException
    extends NotSupportedException {
        private SmartPushNotSupportedException(String message) {
            super(message);
        }
    }

    private static enum GeneralResult {
        SUCCESS,
        CANCELLED,
        NOT_AUTHORIZED;

    }
}

