/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Ticket;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import git4idea.history.GitHistoryUtils;
import git4idea.history.NewGitUsersComponent;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.ChangesFilter;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.ByRootLoader;
import git4idea.history.wholeTree.CommitHashPlusParents;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GitCommitsSequentially;
import git4idea.history.wholeTree.GitLogFilters;
import git4idea.history.wholeTree.LoadAlgorithm;
import git4idea.history.wholeTree.LoadGrowthController;
import git4idea.history.wholeTree.Loader;
import git4idea.history.wholeTree.LoaderAndRefresher;
import git4idea.history.wholeTree.LoaderAndRefresherImpl;
import git4idea.history.wholeTree.Mediator;
import git4idea.history.wholeTree.RootsHolder;
import git4idea.history.wholeTree.UsersIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LoadController
implements Loader {
    private final UsersIndex myUsersIndex;
    private final Project myProject;
    private final Mediator myMediator;
    private final DetailsCache myDetailsCache;
    private final GitCommitsSequentially myGitCommitsSequentially;
    private LoadAlgorithm myPreviousAlgorithm;
    private NewGitUsersComponent myUsersComponent;
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.wholeTree.LoadController");
    private final Map<VirtualFile, Long> mySortOrder;

    public LoadController(Project project, Mediator mediator, DetailsCache detailsCache, GitCommitsSequentially gitCommitsSequentially) {
        this.myProject = project;
        this.myMediator = mediator;
        this.myDetailsCache = detailsCache;
        this.myGitCommitsSequentially = gitCommitsSequentially;
        this.myUsersIndex = new UsersIndex();
        this.myUsersComponent = NewGitUsersComponent.getInstance(this.myProject);
        this.mySortOrder = new HashMap<VirtualFile, Long>();
    }

    @Override
    public void loadSkeleton(final Ticket ticket, RootsHolder rootsHolder, final Collection<String> startingPoints, final GitLogFilters gitLogFilters, final LoadGrowthController loadGrowthController, final boolean topoOrder) {
        if (this.myPreviousAlgorithm != null) {
            this.myPreviousAlgorithm.stop();
        }
        final ArrayList list = new ArrayList();
        ArrayList<ByRootLoader> shortLoaders = new ArrayList<ByRootLoader>();
        List<VirtualFile> roots = rootsHolder.getRoots();
        int i = 0;
        for (VirtualFile root : roots) {
            LoaderAndRefresherImpl.MyRootHolder rootHolder;
            LoaderAndRefresherImpl.MyRootHolder myRootHolder = rootHolder = roots.size() == 1 ? new LoaderAndRefresherImpl.OneRootHolder(root) : new LoaderAndRefresherImpl.ManyCaseHolder(i, rootsHolder);
            if (!gitLogFilters.isUseOnlyHashes()) {
                final boolean haveStructureFilter = gitLogFilters.haveStructureFilter();
                if (haveStructureFilter && !gitLogFilters.haveStructuresForRoot(root)) {
                    ++i;
                    continue;
                }
                gitLogFilters.callConsumer(new Consumer<List<ChangesFilter.Filter>>(){

                    public void consume(List<ChangesFilter.Filter> filters) {
                        LoaderAndRefresherImpl loaderAndRefresher = new LoaderAndRefresherImpl(ticket, filters, LoadController.this.myMediator, startingPoints, LoadController.this.myDetailsCache, LoadController.this.myProject, rootHolder, LoadController.this.myUsersIndex, loadGrowthController.getId(), haveStructureFilter, topoOrder, gitLogFilters.haveDisordering());
                        list.add(loaderAndRefresher);
                    }
                }, true, root);
            }
            shortLoaders.add(new ByRootLoader(this.myProject, rootHolder, this.myMediator, this.myDetailsCache, ticket, this.myUsersIndex, gitLogFilters, startingPoints));
            ++i;
        }
        this.myUsersComponent.acceptUpdate(this.myUsersIndex.getKeys());
        if (this.myPreviousAlgorithm != null) {
            Continuation oldContinuation = this.myPreviousAlgorithm.getContinuation();
            oldContinuation.cancelCurrent();
            oldContinuation.clearQueue();
        }
        final RepositoriesSorter sorter = new RepositoriesSorter(list, shortLoaders);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Continuation continuation = Continuation.createForCurrentProgress((Project)LoadController.this.myProject, (boolean)true, (String)"Load git log data");
                sorter.setContinuation(continuation);
                continuation.add(Arrays.asList(new TaskDescriptor[]{sorter}));
                continuation.resume();
            }
        };
        this.loadUnderProgress(runnable);
    }

    private void loadUnderProgress(final Runnable runnable) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Load git log data", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/wholeTree/LoadController$3", "run"));
                }
                runnable.run();
            }
        });
    }

    @Override
    public void resume() {
        assert (this.myPreviousAlgorithm != null);
        this.loadUnderProgress(new Runnable(){

            @Override
            public void run() {
                LoadController.this.myPreviousAlgorithm.resume();
            }
        });
    }

    private class RepositoriesSorter
    extends TaskDescriptor {
        private final List<LoaderAndRefresher<CommitHashPlusParents>> mySimpleLoaders;
        private final List<ByRootLoader> myShortLoaders;
        private Continuation myContinuation;

        private RepositoriesSorter(List<LoaderAndRefresher<CommitHashPlusParents>> simpleLoaders, List<ByRootLoader> shortLoaders) {
            super("Order repositories", Where.POOLED);
            this.mySimpleLoaders = simpleLoaders;
            this.myShortLoaders = shortLoaders;
            LoadController.this.myPreviousAlgorithm = new LoadAlgorithm(LoadController.this.myProject, this.mySimpleLoaders, this.myShortLoaders, LoadController.this.myGitCommitsSequentially);
        }

        private void setContinuation(Continuation continuation) {
            this.myContinuation = continuation;
            LoadController.this.myPreviousAlgorithm.setContinuation(continuation);
        }

        public void run(ContinuationContext context) {
            assert (this.myContinuation != null);
            HashMap<VirtualFile, CachedRefs> map = new HashMap<VirtualFile, CachedRefs>();
            for (ByRootLoader byRootLoader : this.myShortLoaders) {
                VirtualFile root = byRootLoader.getRootHolder().getRoot();
                CachedRefs refs = byRootLoader.initSymbRefs();
                map.put(root, refs);
                try {
                    long ts = GitHistoryUtils.getHeadTs(LoadController.this.myProject, (FilePath)new FilePathImpl(root));
                    LoadController.this.mySortOrder.put(root, ts);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
            for (LoaderAndRefresher loaderAndRefresher : this.mySimpleLoaders) {
                loaderAndRefresher.setSymbolicRefs((SymbolicRefsI)map.get(loaderAndRefresher.getRoot()));
            }
            Collections.sort(this.myShortLoaders, new Comparator<ByRootLoader>(){

                @Override
                public int compare(ByRootLoader rl1, ByRootLoader rl2) {
                    Long pair1 = (Long)LoadController.this.mySortOrder.get(rl1.getRootHolder().getRoot());
                    Long pair2 = (Long)LoadController.this.mySortOrder.get(rl2.getRootHolder().getRoot());
                    return Comparing.compare((Comparable)pair2, (Comparable)pair1);
                }
            });
            Collections.sort(this.mySimpleLoaders, new Comparator<LoaderAndRefresher<CommitHashPlusParents>>(){

                @Override
                public int compare(LoaderAndRefresher<CommitHashPlusParents> lr1, LoaderAndRefresher<CommitHashPlusParents> lr2) {
                    Long pair1 = (Long)LoadController.this.mySortOrder.get(lr1.getRoot());
                    Long pair2 = (Long)LoadController.this.mySortOrder.get(lr2.getRoot());
                    return Comparing.compare((Comparable)pair2, (Comparable)pair1);
                }
            });
            LoadController.this.myPreviousAlgorithm.fillContinuation();
        }
    }
}

