/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.persistent.SmallMapSerializer;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ThrowableIterator;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import git4idea.GitRevisionNumber;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.SHAHash;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.GitCommitsSequentially;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitCommitsSequentialIndex
implements GitCommitsSequentially {
    private final Object myLock = new Object();
    private final File myListFile;
    private static final int ourInterval = 1000;
    private static final int ourRecordSize = 52;
    private final SLRUMap<VirtualFile, List<Long>> myPacks;
    private final SLRUMap<Pair<Long, VirtualFile>, List<Pair<AbstractHash, Long>>> myCache;
    private final File myDir;
    private SmallMapSerializer<String, String> myState;
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.wholeTree.GitCommitsSequentialIndex");

    public GitCommitsSequentialIndex() {
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        this.myDir = new File(vcsFile, "git_line");
        this.myDir.mkdirs();
        this.myListFile = new File(this.myDir, "repository_index");
        this.myCache = new SLRUMap(10, 10);
        this.myPacks = new SLRUMap(10, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == null) {
                this.myState = new SmallMapSerializer(this.myListFile, (KeyDescriptor)new EnumeratorStringDescriptor(), this.createExternalizer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == null) {
                LOG.info("Deactivate without activate");
                return;
            }
            this.myState.force();
            this.myState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPutRootPath(VirtualFile root) throws VcsException {
        Object object = this.myLock;
        synchronized (object) {
            String key = FilePathsHelper.convertPath((VirtualFile)root);
            String storedName = (String)this.myState.get((Object)key);
            if (storedName != null) {
                return storedName;
            }
            File tempFile = null;
            try {
                tempFile = File.createTempFile(root.getNameWithoutExtension(), ".dat", this.myDir);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            String path = tempFile.getPath();
            this.myState.put((Object)key, (Object)path);
            this.myState.force();
            return path;
        }
    }

    private DataExternalizer<String> createExternalizer() {
        return new DataExternalizer<String>(){

            public void save(@NotNull DataOutput out, String value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/wholeTree/GitCommitsSequentialIndex$1", "save"));
                }
                out.writeUTF(value);
            }

            public String read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/wholeTree/GitCommitsSequentialIndex$1", "read"));
                }
                return in.readUTF();
            }
        };
    }

    private List<Long> getPacksWithLoad(VirtualFile file, String pathToFile) throws VcsException {
        ArrayList<Long> packs = (ArrayList<Long>)this.myPacks.get((Object)file);
        if (packs == null) {
            packs = this.loadPacks(file, pathToFile);
        }
        return packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLineTroughPacks(VirtualFile file, String pathToFile, long ts) throws VcsException {
        Object object = this.myLock;
        synchronized (object) {
            List<Long> packs = this.getPacksWithLoad(file, pathToFile);
            if (packs == null) {
                return -1;
            }
            int found = Collections.binarySearch(packs, ts, Collections.reverseOrder());
            if (found >= 0) {
                while (found > 0 && packs.get(found - 1) == ts) {
                    --found;
                }
                return found == 0 ? 0 : found - 1;
            }
            int insertPlace = -found - 1;
            int n = insertPlace == 0 ? 0 : insertPlace - 1;
            return n;
        }
    }

    public static Pair<AbstractHash, Long> parseRecord(String line) throws VcsException {
        int spaceIdx = line.indexOf(32);
        if (spaceIdx == -1) {
            throw new VcsException("Can not parse written index file");
        }
        try {
            long next = Long.parseLong(line.substring(spaceIdx + 1));
            return new Pair((Object)AbstractHash.create(line.substring(0, spaceIdx)), (Object)(next * 1000L));
        }
        catch (NumberFormatException e) {
            throw new VcsException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<AbstractHash, Long>> loadPack(VirtualFile file, long packNumber) throws VcsException {
        ArrayList<Pair<AbstractHash, Long>> data = new ArrayList<Pair<AbstractHash, Long>>();
        Object object = this.myLock;
        synchronized (object) {
            String key = FilePathsHelper.convertPath((VirtualFile)file);
            String outFileName = (String)this.myState.get((Object)key);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(outFileName, "r");
                long len = raf.length();
                long offset = len - packNumber * 1000L * 52L;
                long recordsInPiece = offset / 52L;
                long size = recordsInPiece >= 1000L ? 1000L : recordsInPiece;
                data.ensureCapacity((int)size);
                raf.seek(offset - size * 52L);
                int i = 0;
                while ((long)i < size && (long)i < len / 52L) {
                    String line = raf.readLine();
                    data.add(GitCommitsSequentialIndex.parseRecord(line));
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
            Collections.reverse(data);
            this.myCache.put((Object)new Pair((Object)packNumber, (Object)file), data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Long> loadPacks(VirtualFile file, String pathToFile) throws VcsException {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<Long> packs = new ArrayList<Long>();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(pathToFile, "r");
                long len = raf.length();
                packs.ensureCapacity((int)(len / 52000L) + 1);
                for (long i = len - 52L; i >= 0L; i -= 52000L) {
                    raf.seek(i);
                    String line = raf.readLine();
                    packs.add((Long)GitCommitsSequentialIndex.parseRecord(line).getSecond());
                }
            }
            catch (FileNotFoundException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
            this.myPacks.put((Object)file, packs);
            return packs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateDescending(VirtualFile file, long commitTime, Processor<Pair<AbstractHash, Long>> consumer) throws VcsException {
        String key = FilePathsHelper.convertPath((VirtualFile)file);
        Object object = this.myLock;
        synchronized (object) {
            Pair<AbstractHash, Long> next;
            int idx;
            String pathToFile = (String)this.myState.get((Object)key);
            if (pathToFile == null || !new File(pathToFile).exists()) {
                return;
            }
            if (commitTime == -1L) {
                idx = 0;
            } else {
                idx = this.findLineTroughPacks(file, pathToFile, commitTime);
                if (idx == -1) {
                    return;
                }
            }
            List<Long> packs = this.getPacksWithLoad(file, pathToFile);
            MyIterator iterator = new MyIterator(file, idx, packs.size());
            if (commitTime != -1L) {
                while (iterator.hasNext()) {
                    next = iterator.next();
                    if ((Long)next.getSecond() > commitTime) continue;
                    if (consumer.process(next)) break;
                    return;
                }
            }
            while (iterator.hasNext() && consumer.process(next = iterator.next())) {
            }
        }
    }

    @Override
    public void pushUpdate(Project project, VirtualFile file, ContinuationContext context) {
        context.next(new TaskDescriptor[]{new LoadTask(file, project)});
    }

    private class LoadTask
    extends TaskDescriptor {
        private final Project myProject;
        private final VirtualFile myFile;

        private LoadTask(VirtualFile file, Project project) {
            super("Refresh repository " + file.getPath() + " cache", Where.POOLED);
            this.myFile = file;
            this.myProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ContinuationContext context) {
            Object object = GitCommitsSequentialIndex.this.myLock;
            synchronized (object) {
                block5: {
                    try {
                        this.loadImpl();
                    }
                    catch (VcsException e) {
                        context.cancelEverything();
                        if (context.handleException((Exception)((Object)e), false)) break block5;
                        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                    }
                }
            }
        }

        private void loadImpl() throws VcsException {
            final AbstractHash[] latestWrittenHash = new AbstractHash[1];
            final Long[] latestWrittenTime = new Long[1];
            GitCommitsSequentialIndex.this.iterateDescending(this.myFile, -1L, new Processor<Pair<AbstractHash, Long>>(){

                public boolean process(Pair<AbstractHash, Long> abstractHashLongPair) {
                    latestWrittenHash[0] = (AbstractHash)abstractHashLongPair.getFirst();
                    latestWrittenTime[0] = (Long)abstractHashLongPair.getSecond();
                    return false;
                }
            });
            if (latestWrittenHash[0] != null) {
                ItemLatestState lastRevision = GitHistoryUtils.getLastRevision(this.myProject, (FilePath)new FilePathImpl(this.myFile));
                if (lastRevision == null) {
                    return;
                }
                if (lastRevision.isItemExists() && ((GitRevisionNumber)lastRevision.getNumber()).getRev().equals(latestWrittenHash[0].getString())) {
                    return;
                }
                this.appendHistory(latestWrittenTime[0], latestWrittenHash[0]);
            } else {
                this.initHistory();
            }
        }

        private void initHistory() throws VcsException {
            String outFilePath = GitCommitsSequentialIndex.this.getPutRootPath(this.myFile);
            GitHistoryUtils.dumpFullHistory(this.myProject, this.myFile, outFilePath);
        }

        private void appendHistory(long since, AbstractHash hash) throws VcsException {
            Pair<SHAHash, Date> next;
            String outFilePath = GitCommitsSequentialIndex.this.getPutRootPath(this.myFile);
            List<Pair<SHAHash, Date>> pairs = GitHistoryUtils.onlyHashesHistory(this.myProject, (FilePath)new FilePathImpl(this.myFile), "--all", "--date-order", "--full-history", "--sparse", "--after=" + since / 1000L);
            if (pairs.isEmpty()) {
                return;
            }
            String startAsString = hash.getString();
            Iterator<Pair<SHAHash, Date>> iterator = pairs.iterator();
            while (iterator.hasNext() && !((SHAHash)(next = iterator.next()).getFirst()).getValue().equals(startAsString)) {
            }
            OutputStream stream = null;
            try {
                stream = new BufferedOutputStream(new FileOutputStream(new File(outFilePath), true));
                while (iterator.hasNext()) {
                    Pair<SHAHash, Date> next2 = iterator.next();
                    stream.write((((SHAHash)next2.getFirst()).getValue() + " " + ((Date)next2.getSecond()).getTime() + '\n').getBytes(CharsetToolkit.UTF8_CHARSET));
                }
            }
            catch (FileNotFoundException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        }
    }

    private class MyIterator
    implements ThrowableIterator<Pair<AbstractHash, Long>, VcsException> {
        private final VirtualFile myFile;
        private int myIdx;
        private final int myPacksSize;
        private Iterator<Pair<AbstractHash, Long>> myCurrent;

        private MyIterator(VirtualFile file, int idx, int packsSize) throws VcsException {
            this.myFile = file;
            this.myIdx = idx;
            this.myPacksSize = packsSize;
            this.initIterator();
        }

        void initIterator() throws VcsException {
            Pair key = new Pair((Object)this.myIdx, (Object)this.myFile);
            List cached = (List)GitCommitsSequentialIndex.this.myCache.get((Object)key);
            if (cached == null) {
                cached = GitCommitsSequentialIndex.this.loadPack(this.myFile, this.myIdx);
                GitCommitsSequentialIndex.this.myCache.put((Object)key, (Object)cached);
            }
            this.myCurrent = cached.iterator();
        }

        public boolean hasNext() {
            return this.myCurrent.hasNext() || this.myIdx < this.myPacksSize;
        }

        public Pair<AbstractHash, Long> next() throws VcsException {
            if (this.myCurrent.hasNext()) {
                return this.myCurrent.next();
            }
            ++this.myIdx;
            this.initIterator();
            return this.myCurrent.next();
        }

        public void remove() throws VcsException {
            throw new UnsupportedOperationException();
        }
    }
}

