/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.util.Ref;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitI;
import java.util.List;

public class Commit
implements Comparable<CommitI>,
CommitI {
    private final AbstractHash myHash;
    private final long myTime;
    private final Ref<Integer> myAuthorIdx;

    public Commit(String hash, long time, Ref<Integer> authorIdx) {
        this.myHash = AbstractHash.create(hash);
        this.myTime = time;
        this.myAuthorIdx = authorIdx;
    }

    public String toString() {
        return this.myHash.getString();
    }

    @Override
    public boolean holdsDecoration() {
        return false;
    }

    @Override
    public String getDecorationString() {
        return null;
    }

    @Override
    public <T> T selectRepository(List<T> repositories) {
        return repositories.get(0);
    }

    @Override
    public AbstractHash getHash() {
        return this.myHash;
    }

    @Override
    public long getTime() {
        return this.myTime;
    }

    @Override
    public int getWireNumber() {
        return -1;
    }

    @Override
    public void setWireNumber(int wireNumber) {
    }

    @Override
    public int compareByName(Commit c) {
        long result = (Integer)this.myAuthorIdx.get() - (Integer)c.myAuthorIdx.get();
        return result == 0L ? 0 : (result < 0L ? -1 : 1);
    }

    @Override
    public int compareTo(CommitI o) {
        long result = this.myTime - o.getTime();
        return result == 0L ? 0 : (result < 0L ? -1 : 1);
    }

    @Override
    public Ref<Integer> getAuthorIdx() {
        return this.myAuthorIdx;
    }
}

