/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.BigArray;
import com.intellij.openapi.vcs.GroupingMerger;
import com.intellij.openapi.vcs.changes.committed.DateChangeListGroupingStrategy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ReadonlyList;
import com.intellij.util.containers.StepList;
import com.intellij.util.ui.ColumnInfo;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitGroupingStrategy;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.CommitIComparator;
import git4idea.history.wholeTree.CommitIReorderingInsideOneRepoComparator;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GroupHeaderDatePseudoCommit;
import git4idea.history.wholeTree.RootsHolder;
import git4idea.history.wholeTree.SkeletonBuilder;
import git4idea.history.wholeTree.TreeHighlighter;
import git4idea.history.wholeTree.TreeNavigationImpl;
import git4idea.history.wholeTree.WireEvent;
import git4idea.history.wholeTree.WireEventI;
import git4idea.history.wholeTree.WireEventsIterator;
import git4idea.history.wholeTree.WireNumberCommitDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigTableTableModel
extends AbstractTableModel {
    public static final Object LOADING = new Object();
    public static final String STASH = "Stash";
    @Nullable
    private Map<VirtualFile, SkeletonBuilder> mySkeletonBuilder;
    @Nullable
    private Map<VirtualFile, TreeNavigationImpl> myNavigation;
    @Nullable
    private List<VirtualFile> myOrder;
    private Map<VirtualFile, Integer> myAdditions;
    private final BidirectionalMap<InnerIdx, Integer> myIdxMap;
    private final Map<VirtualFile, TreeSet<Integer>> myRepoIdxMap;
    private final Map<VirtualFile, Integer> myRunningRepoIdxs;
    @NotNull
    private final List<ColumnInfo> myColumns;
    private RootsHolder myRootsHolder;
    @Nullable
    private StepList<CommitI> myLines;
    private int myCutCount;
    private DetailsCache myCache;
    private Runnable myInit;
    private CommitGroupingStrategy myStrategy;
    private Comparator<CommitI> myCurrentComparator;
    private int myCommitIdxInterval;
    private int myNumEventsInGroup;
    private final Set<VirtualFile> myActiveRoots;
    private final CommitGroupingStrategy myDefaultStrategy;
    private final CommitGroupingStrategy myNoGrouping;
    private final Map<VirtualFile, Pair<AbstractHash, AbstractHash>> myStashTops;
    private final Map<VirtualFile, TreeHighlighter> myTreeHighlighter;

    public BigTableTableModel(@NotNull List<ColumnInfo> columns, Runnable init) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/wholeTree/BigTableTableModel", "<init>"));
        }
        this.myColumns = columns;
        this.myInit = init;
        this.myIdxMap = new BidirectionalMap();
        this.myRunningRepoIdxs = new HashMap<VirtualFile, Integer>();
        this.myRepoIdxMap = new HashMap<VirtualFile, TreeSet<Integer>>();
        this.myActiveRoots = new HashSet<VirtualFile>();
        this.myCurrentComparator = CommitIReorderingInsideOneRepoComparator.getInstance();
        final DateChangeListGroupingStrategy delegate = new DateChangeListGroupingStrategy();
        this.myStrategy = this.myDefaultStrategy = new CommitGroupingStrategy(){

            @Override
            public void beforeStart() {
                delegate.beforeStart();
            }

            @Override
            public String getGroupName(CommitI commit) {
                return delegate.getGroupName(new Date(commit.getTime()));
            }
        };
        this.myLines = new BigArray(10);
        this.myCutCount = -1;
        this.myCommitIdxInterval = 50;
        this.myNumEventsInGroup = 20;
        this.myNoGrouping = new CommitGroupingStrategy(){

            @Override
            public String getGroupName(CommitI commit) {
                return null;
            }

            @Override
            public void beforeStart() {
            }
        };
        this.myStashTops = new HashMap<VirtualFile, Pair<AbstractHash, AbstractHash>>();
        this.myTreeHighlighter = new HashMap<VirtualFile, TreeHighlighter>();
    }

    public boolean isForRoot(VirtualFile root, int idx) {
        return this.myRepoIdxMap.get(root).contains(idx);
    }

    public int getAbsoluteForRelative(VirtualFile root, int insideRepoIdx) {
        return (Integer)this.myIdxMap.get((Object)new InnerIdx(root, insideRepoIdx));
    }

    public int getPreviousAbsoluteIdx(int idx) {
        VirtualFile root = this.getCommitAt(idx).selectRepository(this.myRootsHolder.getRoots());
        List keysByValue = this.myIdxMap.getKeysByValue((Object)idx);
        if (keysByValue == null) {
            return -1;
        }
        for (InnerIdx innerIdx : keysByValue) {
            if (!innerIdx.getRoot().equals(root)) continue;
            if (innerIdx.getInsideRepoIdx() == 0) {
                return -1;
            }
            return (Integer)this.myIdxMap.get((Object)new InnerIdx(root, innerIdx.getInsideRepoIdx() - 1));
        }
        return -1;
    }

    public void setCommitIdxInterval(int commitIdxInterval) {
        this.myCommitIdxInterval = commitIdxInterval;
    }

    public void setNumEventsInGroup(int numEventsInGroup) {
        this.myNumEventsInGroup = numEventsInGroup;
    }

    public ColumnInfo getColumnInfo(int column) {
        return this.myColumns.get(column);
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumns.get(column).getName();
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.size();
    }

    int getTrueCount() {
        return this.myLines == null ? 0 : this.myLines.getSize();
    }

    @Override
    public int getRowCount() {
        if (this.myInit != null) {
            Runnable init = this.myInit;
            this.myInit = null;
            init.run();
        }
        if (this.myCutCount > 0) {
            return this.myCutCount;
        }
        return this.myLines == null ? 0 : this.myLines.getSize();
    }

    public CommitI getCommitAt(int row) {
        if (this.myLines == null) {
            return null;
        }
        if (row >= this.myLines.getSize()) {
            return null;
        }
        return (CommitI)this.myLines.get(row);
    }

    public int getTotalWires() {
        if (this.mySkeletonBuilder == null) {
            return -1;
        }
        int wires = 0;
        for (Map.Entry<VirtualFile, SkeletonBuilder> entry : this.mySkeletonBuilder.entrySet()) {
            SkeletonBuilder skeletonBuilder = entry.getValue();
            if (!this.myActiveRoots.contains(entry.getKey())) continue;
            wires += skeletonBuilder.getMaxWireNum();
        }
        return wires;
    }

    @Nullable
    public List<Integer> getWiresGroups() {
        if (this.mySkeletonBuilder == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(this.myOrder.size());
        for (VirtualFile file : this.myOrder) {
            if (!this.myActiveRoots.contains(file)) continue;
            result.add(this.mySkeletonBuilder.get(file).getMaxWireNum());
        }
        return result;
    }

    public int getCorrectedWire(CommitI commitI) {
        if (this.mySkeletonBuilder == null) {
            return -1;
        }
        VirtualFile file = commitI.selectRepository(this.myRootsHolder.getRoots());
        if (!this.myAdditions.containsKey(file)) {
            return commitI.getWireNumber();
        }
        return this.myAdditions.get(file) + commitI.getWireNumber();
    }

    public int getRepoCorrection(VirtualFile root) {
        return this.myAdditions.get(root);
    }

    public Map<VirtualFile, WireEventsIterator> getGroupIterators(int firstRow) {
        HashMap<VirtualFile, WireEventsIterator> map = new HashMap<VirtualFile, WireEventsIterator>();
        for (VirtualFile virtualFile : this.mySkeletonBuilder.keySet()) {
            if (!this.myActiveRoots.contains(virtualFile)) continue;
            map.put(virtualFile, new WiresGroupIterator(firstRow, virtualFile));
        }
        return map;
    }

    public Map<VirtualFile, WireEventsIterator> getAllGroupIterators(int firstRow) {
        HashMap<VirtualFile, WireEventsIterator> map = new HashMap<VirtualFile, WireEventsIterator>();
        for (VirtualFile virtualFile : this.mySkeletonBuilder.keySet()) {
            map.put(virtualFile, new WiresGroupIterator(firstRow, virtualFile));
        }
        return map;
    }

    public void stashFor(VirtualFile root, Pair<AbstractHash, AbstractHash> hash) {
        this.myStashTops.put(root, hash);
    }

    public boolean isStashed(CommitI commitI) {
        Pair<AbstractHash, AbstractHash> pair = this.myStashTops.get(commitI.selectRepository(this.myRootsHolder.getRoots()));
        return pair != null && (pair.getFirst() != null && ((AbstractHash)pair.getFirst()).equals(commitI.getHash()) || pair.getSecond() != null && ((AbstractHash)pair.getSecond()).equals(commitI.getHash()));
    }

    public void setHeadIfEmpty(VirtualFile root, AbstractHash headHash) {
        TreeHighlighter treeHighlighter = this.myTreeHighlighter.get(root);
        if (treeHighlighter != null && treeHighlighter.getPoint() == null) {
            this.setHead(root, headHash);
        }
    }

    public void setHead(VirtualFile root, AbstractHash headHash) {
        TreeHighlighter treeHighlighter = this.myTreeHighlighter.get(root);
        if (treeHighlighter != null) {
            if (!treeHighlighter.isDumb() && headHash.equals(treeHighlighter.getPoint())) {
                return;
            }
            treeHighlighter.setPoint(headHash);
            treeHighlighter.update(0);
        }
    }

    public void setDumbHighlighter(VirtualFile root) {
        TreeHighlighter treeHighlighter = this.myTreeHighlighter.get(root);
        if (treeHighlighter != null) {
            if (treeHighlighter.isDumb()) {
                return;
            }
            treeHighlighter.setDumb();
        }
    }

    public int getLastForRoot(VirtualFile root) {
        TreeSet<Integer> integers = this.myRepoIdxMap.get(root);
        if (integers.isEmpty()) {
            return -1;
        }
        return integers.last();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColumnInfo column = this.myColumns.get(columnIndex);
        if (this.myLines == null) {
            return column.getPreferredStringValue();
        }
        CommitI commitI = (CommitI)this.myLines.get(rowIndex);
        if (commitI == null) {
            return column.getPreferredStringValue();
        }
        if (commitI.holdsDecoration()) {
            return columnIndex == 0 ? commitI.getDecorationString() : "";
        }
        GitHeavyCommit details = this.myCache.convert(commitI.selectRepository(this.myRootsHolder.getRoots()), commitI.getHash());
        if (details == null) {
            return LOADING;
        }
        return column.valueOf((Object)details);
    }

    public MultiMap<VirtualFile, AbstractHash> getMissing(int startRow, int endRow) {
        if (this.myLines == null || this.myRootsHolder == null) {
            return MultiMap.emptyInstance();
        }
        MultiMap result = new MultiMap();
        for (int i = startRow; i <= endRow; ++i) {
            CommitI commitI = (CommitI)this.myLines.get(i);
            if (commitI.holdsDecoration()) continue;
            AbstractHash hash = commitI.getHash();
            VirtualFile root = commitI.selectRepository(this.myRootsHolder.getRoots());
            if (this.myCache.convert(root, commitI.getHash()) != null) continue;
            result.putValue((Object)root, (Object)hash);
        }
        return result;
    }

    public void clear(boolean noFilters, boolean noStartingPoints) {
        if (noFilters) {
            this.myCurrentComparator = CommitIComparator.getInstance();
            this.myNavigation = new HashMap<VirtualFile, TreeNavigationImpl>();
            this.mySkeletonBuilder = new HashMap<VirtualFile, SkeletonBuilder>();
            this.myAdditions = new HashMap<VirtualFile, Integer>();
            this.myOrder = new ArrayList<VirtualFile>(this.myRootsHolder.getRoots());
            Collections.sort(this.myOrder, FilePathComparator.getInstance());
            for (VirtualFile vf : this.myOrder) {
                TreeNavigationImpl navigation = new TreeNavigationImpl(this.myCommitIdxInterval, this.myNumEventsInGroup);
                SkeletonBuilder skeletonBuilder = new SkeletonBuilder(navigation);
                this.myNavigation.put(vf, navigation);
                this.mySkeletonBuilder.put(vf, skeletonBuilder);
                this.myAdditions.put(vf, 0);
                this.myRepoIdxMap.put(vf, new TreeSet());
                this.myRunningRepoIdxs.put(vf, 0);
                this.myIdxMap.clear();
            }
            for (VirtualFile virtualFile : this.myOrder) {
                if (this.myTreeHighlighter.containsKey(virtualFile)) continue;
                this.myTreeHighlighter.put(virtualFile, new TreeHighlighter(this, virtualFile, -1));
            }
            Iterator<VirtualFile> iterator = this.myTreeHighlighter.keySet().iterator();
            while (iterator.hasNext()) {
                VirtualFile root = iterator.next();
                if (!this.myOrder.contains(root)) {
                    iterator.remove();
                    continue;
                }
                TreeHighlighter highlighter = this.myTreeHighlighter.get(root);
                highlighter.setPoint(highlighter.getPoint());
            }
        } else {
            this.myCurrentComparator = CommitIReorderingInsideOneRepoComparator.getInstance();
            this.myAdditions = null;
            this.mySkeletonBuilder = null;
            this.myNavigation = null;
            this.myOrder = null;
            this.myTreeHighlighter.clear();
        }
        this.myLines = new BigArray(10);
        this.myCutCount = -1;
    }

    @Nullable
    public List<VirtualFile> getOrder() {
        return this.myOrder;
    }

    public void cutAt(int lastShownItemIdx) {
        this.myCutCount = lastShownItemIdx + 1;
    }

    public void restore() {
        this.myCutCount = -1;
    }

    public void appendData(List<CommitI> lines, final List<List<AbstractHash>> parents) {
        if (this.mySkeletonBuilder == null) {
            Collections.sort(lines, this.myCurrentComparator);
        }
        this.myStrategy.beforeStart();
        final int[] parentsIdx = new int[]{0};
        int idxFrom = this.findIdx(lines);
        CommitI commitI = lines.get(0);
        final VirtualFile listRoot = commitI.selectRepository(this.myRootsHolder.getRoots());
        final ReadonlyList<CommitI> wrapperList = this.createWrapper(listRoot);
        int recountFrom = new GroupingMerger<CommitI, String>(){

            protected CommitI wrapItem(CommitI commitI) {
                if (BigTableTableModel.this.mySkeletonBuilder != null && !commitI.holdsDecoration()) {
                    return new WireNumberCommitDecoration(commitI);
                }
                return (CommitI)super.wrapItem((Object)commitI);
            }

            protected void afterConsumed(CommitI commitI, int i) {
                if (BigTableTableModel.this.mySkeletonBuilder != null && !commitI.holdsDecoration()) {
                    VirtualFile root = commitI.selectRepository(BigTableTableModel.this.myRootsHolder.getRoots());
                    Integer innerIdx = (Integer)BigTableTableModel.this.myRunningRepoIdxs.get(root);
                    BigTableTableModel.this.myIdxMap.put((Object)new InnerIdx(root, innerIdx), (Object)i);
                    ((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(root)).add(i);
                    BigTableTableModel.this.myRunningRepoIdxs.put(root, innerIdx + 1);
                    ((SkeletonBuilder)BigTableTableModel.this.mySkeletonBuilder.get(root)).consume(commitI, (List)parents.get(parentsIdx[0]), (ReadonlyList<CommitI>)wrapperList, innerIdx);
                    parentsIdx[0] = parentsIdx[0] + 1;
                }
            }

            protected boolean filter(CommitI commitI) {
                return !commitI.holdsDecoration();
            }

            protected void willBeRecountFrom(int idx, int wasSize) {
                if (BigTableTableModel.this.mySkeletonBuilder != null) {
                    for (int i = idx; i < wasSize; ++i) {
                        for (VirtualFile root : BigTableTableModel.this.myOrder) {
                            ((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(root)).remove(i);
                        }
                    }
                }
            }

            protected String getGroup(CommitI commitI) {
                Pair stashTop;
                if (this.getCurrentGroup() == null && (stashTop = (Pair)BigTableTableModel.this.myStashTops.get(commitI.selectRepository(BigTableTableModel.this.myRootsHolder.getRoots()))) != null && Comparing.equal((Object)stashTop.getFirst(), (Object)commitI.getHash())) {
                    return BigTableTableModel.STASH;
                }
                if (BigTableTableModel.STASH.equals(this.getCurrentGroup())) {
                    VirtualFile root = commitI.selectRepository(BigTableTableModel.this.myRootsHolder.getRoots());
                    Pair stashTop2 = (Pair)BigTableTableModel.this.myStashTops.get(root);
                    if (stashTop2 != null && Comparing.equal((Object)stashTop2.getSecond(), (Object)commitI.getHash())) {
                        return BigTableTableModel.STASH;
                    }
                }
                return BigTableTableModel.this.myStrategy.getGroupName(commitI);
            }

            protected CommitI wrapGroup(String s, CommitI item) {
                return new GroupHeaderDatePseudoCommit(s, item.getTime() - 1L);
            }

            protected void oldBecame(int was, int is) {
                if (BigTableTableModel.this.mySkeletonBuilder != null) {
                    List keys = BigTableTableModel.this.myIdxMap.getKeysByValue((Object)was);
                    VirtualFile root = ((CommitI)BigTableTableModel.this.myLines.get(is)).selectRepository(BigTableTableModel.this.myRootsHolder.getRoots());
                    assert (!root.equals(listRoot));
                    ((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(root)).add(is);
                    InnerIdx found = null;
                    for (InnerIdx key : keys) {
                        if (!key.getRoot().equals(root)) continue;
                        found = key;
                        break;
                    }
                    assert (found != null);
                    BigTableTableModel.this.myIdxMap.put(found, (Object)is);
                }
            }
        }.firstPlusSecond(this.myLines, (ReadonlyList)new ReadonlyList.ArrayListWrapper(lines), this.myCurrentComparator, this.mySkeletonBuilder == null ? -1 : idxFrom);
        if (this.mySkeletonBuilder != null) {
            TreeNavigationImpl treeNavigation = this.myNavigation.get(listRoot);
            treeNavigation.recalcIndex(wrapperList, this.mySkeletonBuilder.get(listRoot).getFutureConvertor());
            this.calculateAdditions();
            for (VirtualFile root : this.myOrder) {
                TreeHighlighter treeHighlighter = this.myTreeHighlighter.get(root);
                if (treeHighlighter == null) continue;
                treeHighlighter.update(recountFrom);
            }
        }
    }

    private void calculateAdditions() {
        if (this.mySkeletonBuilder != null) {
            int size = 0;
            this.myAdditions.clear();
            for (VirtualFile file : this.myOrder) {
                if (!this.myActiveRoots.contains(file)) continue;
                this.myAdditions.put(file, size);
                size += this.mySkeletonBuilder.get(file).getMaxWireNum();
            }
        }
    }

    public boolean isInCurrentBranch(int idx) {
        if (this.mySkeletonBuilder == null || this.myTreeHighlighter.isEmpty()) {
            return false;
        }
        CommitI commitAt = this.getCommitAt(idx);
        if (commitAt.holdsDecoration()) {
            return false;
        }
        VirtualFile root = commitAt.selectRepository(this.myRootsHolder.getRoots());
        TreeHighlighter treeHighlighter = this.myTreeHighlighter.get(root);
        return treeHighlighter != null && treeHighlighter.isIncluded(commitAt.getHash());
    }

    public Map<Integer, Set<Integer>> getGrey(VirtualFile root, int from, int to, int repoCorrection, Set<Integer> wireModificationSet) {
        if (this.mySkeletonBuilder == null || this.myTreeHighlighter.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeHighlighter highlighter = this.myTreeHighlighter.get(root);
        return highlighter.getGreyForInterval(from, to, repoCorrection, wireModificationSet);
    }

    private ReadonlyList<CommitI> createWrapper(final VirtualFile root) {
        return new ReadonlyList<CommitI>(){

            public CommitI get(int idx) {
                return (CommitI)BigTableTableModel.this.myLines.get(((Integer)BigTableTableModel.this.myIdxMap.get((Object)new InnerIdx(root, idx))).intValue());
            }

            public int getSize() {
                return (Integer)BigTableTableModel.this.myRunningRepoIdxs.get(root);
            }
        };
    }

    private int findIdx(List<CommitI> lines) {
        VirtualFile targetRepo = lines.get(0).selectRepository(this.myRootsHolder.getRoots());
        long time = lines.get(0).getTime();
        for (int i = this.myLines.getSize() - 1; i >= 0; --i) {
            CommitI current = (CommitI)this.myLines.get(i);
            if (current.holdsDecoration()) continue;
            if (current.selectRepository(this.myRootsHolder.getRoots()).equals(targetRepo)) {
                return i + 1;
            }
            if (current.getTime() <= time) continue;
            return i;
        }
        return 0;
    }

    public void setCache(DetailsCache cache) {
        this.myCache = cache;
    }

    public void setRootsHolder(RootsHolder rootsHolder) {
        this.myRootsHolder = rootsHolder;
    }

    public RootsHolder getRootsHolder() {
        return this.myRootsHolder;
    }

    public void setStrategy(CommitGroupingStrategy strategy) {
        this.myStrategy = strategy;
    }

    public void useDateGroupingStrategy() {
        this.myStrategy = this.myDefaultStrategy;
    }

    public void useNoGroupingStrategy() {
        this.myStrategy = this.myNoGrouping;
    }

    public void printNavigation() {
        for (Map.Entry<VirtualFile, TreeNavigationImpl> entry : this.myNavigation.entrySet()) {
            if (!entry.getKey().getPath().contains("inner")) continue;
            entry.getValue().printSelf();
        }
    }

    public Set<VirtualFile> getActiveRoots() {
        return this.myActiveRoots;
    }

    public void setActiveRoots(Collection<VirtualFile> files) {
        this.myActiveRoots.clear();
        this.myActiveRoots.addAll(files);
        for (TreeHighlighter highlighter : this.myTreeHighlighter.values()) {
            highlighter.update(0);
        }
        this.calculateAdditions();
    }

    public static class InnerIdx {
        private final VirtualFile myRoot;
        private final int myInsideRepoIdx;

        public InnerIdx(VirtualFile root, int insideRepoIdx) {
            this.myRoot = root;
            this.myInsideRepoIdx = insideRepoIdx;
        }

        public VirtualFile getRoot() {
            return this.myRoot;
        }

        public int getInsideRepoIdx() {
            return this.myInsideRepoIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerIdx innerIdx = (InnerIdx)o;
            if (this.myInsideRepoIdx != innerIdx.myInsideRepoIdx) {
                return false;
            }
            return this.myRoot.equals(innerIdx.myRoot);
        }

        public int hashCode() {
            int result = this.myRoot.hashCode();
            result = 31 * result + this.myInsideRepoIdx;
            return result;
        }
    }

    class WiresGroupIterator
    implements WireEventsIterator {
        private final int myFirstIdxAbs;
        private List<Integer> myFirstUsed;
        private final VirtualFile myRoot;
        private final int myOffset;
        private final Iterator<WireEvent> myWireEventsIterator;
        private Integer myFloor;
        private int myIdx;

        WiresGroupIterator(int firstIdxAbs, VirtualFile root) {
            this.myFirstIdxAbs = firstIdxAbs;
            this.myRoot = root;
            this.myOffset = BigTableTableModel.this.myAdditions.containsKey(this.myRoot) ? (Integer)BigTableTableModel.this.myAdditions.get(this.myRoot) : 0;
            this.myFirstUsed = new ArrayList<Integer>();
            TreeNavigationImpl navigation = (TreeNavigationImpl)BigTableTableModel.this.myNavigation.get(this.myRoot);
            ReadonlyList wrapper = BigTableTableModel.this.createWrapper(this.myRoot);
            this.myFloor = ((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(this.myRoot)).floor(firstIdxAbs);
            if (this.myFloor == null) {
                this.myIdx = 0;
                this.myFloor = ((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(this.myRoot)).isEmpty() ? 0 : (Integer)((TreeSet)BigTableTableModel.this.myRepoIdxMap.get(this.myRoot)).first();
            } else {
                List keysByValue = BigTableTableModel.this.myIdxMap.getKeysByValue((Object)this.myFloor);
                this.myIdx = -1;
                for (InnerIdx innerIdx : keysByValue) {
                    if (!innerIdx.getRoot().equals(this.myRoot)) continue;
                    this.myIdx = innerIdx.getInsideRepoIdx();
                    break;
                }
                assert (this.myIdx != -1);
            }
            List used = navigation.getUsedWires(this.myIdx, (ReadonlyList<CommitI>)wrapper, ((SkeletonBuilder)BigTableTableModel.this.mySkeletonBuilder.get(this.myRoot)).getFutureConvertor()).getUsed();
            for (Integer integer : used) {
                this.myFirstUsed.add(integer + this.myOffset);
            }
            this.myWireEventsIterator = navigation.createWireEventsIterator(this.myIdx);
        }

        @Override
        public Integer getFloor() {
            return this.myFloor;
        }

        @Override
        public Iterator<WireEventI> getWireEventsIterator() {
            return new Iterator<WireEventI>(){

                @Override
                public boolean hasNext() {
                    return WiresGroupIterator.this.myWireEventsIterator.hasNext();
                }

                @Override
                public WireEventI next() {
                    WireEventI next = (WireEventI)WiresGroupIterator.this.myWireEventsIterator.next();
                    Convertor<Integer, Integer> innerToOuter = new Convertor<Integer, Integer>(){

                        public Integer convert(Integer o) {
                            if (o == -1) {
                                return -1;
                            }
                            int insideRepoIdx = o;
                            Integer integer = (Integer)BigTableTableModel.this.myIdxMap.get((Object)new InnerIdx(WiresGroupIterator.this.myRoot, insideRepoIdx));
                            assert (integer != null);
                            return integer;
                        }
                    };
                    Convertor<int[], int[]> arraysConvertor = new Convertor<int[], int[]>((Convertor)innerToOuter){
                        final /* synthetic */ Convertor val$innerToOuter;
                        {
                            this.val$innerToOuter = convertor;
                        }

                        public int[] convert(int[] o) {
                            if (o == null) {
                                return null;
                            }
                            int[] result = new int[o.length];
                            for (int i = 0; i < o.length; ++i) {
                                int i1 = o[i];
                                result[i] = (Integer)this.val$innerToOuter.convert((Object)i1);
                            }
                            return result;
                        }
                    };
                    return new WireEventI((Convertor)innerToOuter, next, (Convertor)arraysConvertor){
                        final /* synthetic */ Convertor val$innerToOuter;
                        final /* synthetic */ WireEventI val$next;
                        final /* synthetic */ Convertor val$arraysConvertor;
                        {
                            this.val$innerToOuter = convertor;
                            this.val$next = wireEventI;
                            this.val$arraysConvertor = convertor2;
                        }

                        @Override
                        public int getCommitIdx() {
                            return (Integer)this.val$innerToOuter.convert((Object)this.val$next.getCommitIdx());
                        }

                        @Override
                        public int[] getWireEnds() {
                            return (int[])this.val$arraysConvertor.convert((Object)this.val$next.getWireEnds());
                        }

                        @Override
                        public int[] getCommitsEnds() {
                            return (int[])this.val$arraysConvertor.convert((Object)this.val$next.getCommitsEnds());
                        }

                        @Override
                        public int[] getCommitsStarts() {
                            return (int[])this.val$arraysConvertor.convert((Object)this.val$next.getCommitsStarts());
                        }

                        @Override
                        public int[] getFutureWireStarts() {
                            return this.val$next.getFutureWireStarts();
                        }

                        @Override
                        public boolean isEnd() {
                            return this.val$next.isEnd();
                        }

                        @Override
                        public boolean isStart() {
                            return this.val$next.isStart();
                        }

                        @Override
                        public int getWaitStartsNumber() {
                            return this.val$next.getWaitStartsNumber();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<Integer> getFirstUsed() {
            return this.myFirstUsed;
        }
    }
}

