/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public abstract class FictiveTableCellRenderer
extends ColoredListCellRenderer {
    protected abstract int getParentWidth(JList var1);

    @Nullable
    protected abstract Color getBgrndColor(JList var1, Object var2, int var3, boolean var4, boolean var5);

    protected abstract Description getDescription(Object var1);

    protected abstract Trinity<String, SimpleTextAttributes, Object> getMoreTag();

    protected abstract boolean willRender(Object var1);

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (!this.willRender(value)) {
            return;
        }
        int parentWidth = this.getParentWidth(list);
        Color bgrndColor = this.getBgrndColor(list, value, index, selected, hasFocus);
        if (bgrndColor != null) {
            this.setBackground(bgrndColor);
        }
        Description description = this.getDescription(value);
        MyFontHelper helper = new MyFontHelper(list);
        int fixedWidth = 0;
        int fixedWidthBefore = 0;
        int changeableWidth = 0;
        List<Pair<String, SimpleTextAttributes>> pieces = description.getPieces();
        int middleIdx = description.getMiddleIdx();
        for (int i = 0; i < pieces.size(); ++i) {
            Pair<String, SimpleTextAttributes> pair = pieces.get(i);
            if (middleIdx == i) {
                changeableWidth = helper.getWidth(pair);
                continue;
            }
            int width = helper.getWidth(pair);
            if (i < middleIdx) {
                fixedWidthBefore += width;
                this.append((String)pair.getFirst(), (SimpleTextAttributes)pair.getSecond());
                String adj = description.getMaxString(i);
                if (adj != null) {
                    int adjWidth = helper.getWidth((Pair<String, SimpleTextAttributes>)new Pair((Object)adj, pair.getSecond()));
                    this.appendFixedTextFragmentWidth(adjWidth);
                    fixedWidth += adjWidth;
                    continue;
                }
                this.appendFixedTextFragmentWidth(width);
                fixedWidth += width;
                continue;
            }
            fixedWidth += width;
        }
        Pair<String, SimpleTextAttributes> changeable = pieces.get(middleIdx);
        int difference = parentWidth - fixedWidth;
        if (fixedWidth + changeableWidth > parentWidth) {
            if (fixedWidth < parentWidth) {
                Trinity<String, SimpleTextAttributes, Object> tag = this.getMoreTag();
                int more = helper.getWidth((Pair<String, SimpleTextAttributes>)new Pair(tag.getFirst(), tag.getSecond()));
                if (more < difference) {
                    String truncated = CommittedChangeListRenderer.truncateDescription((String)((String)changeable.getFirst()), (FontMetrics)helper.getFontMetrics((SimpleTextAttributes)changeable.getSecond()), (int)(difference - more));
                    int truncatedWidth = helper.getWidth((Pair<String, SimpleTextAttributes>)new Pair((Object)truncated, changeable.getSecond()));
                    this.append(truncated, (SimpleTextAttributes)changeable.getSecond());
                    this.append((String)tag.getFirst(), (SimpleTextAttributes)tag.getSecond(), tag.getThird());
                    if (truncatedWidth > 0) {
                        this.appendFixedTextFragmentWidth(difference - truncatedWidth);
                    }
                } else {
                    this.appendFixedTextFragmentWidth(difference);
                }
            }
        } else {
            this.append((String)changeable.getFirst(), (SimpleTextAttributes)changeable.getSecond());
            this.appendFixedTextFragmentWidth(parentWidth - fixedWidth);
        }
        for (int i = middleIdx + 1; i < pieces.size(); ++i) {
            Pair<String, SimpleTextAttributes> pair = pieces.get(i);
            this.append((String)pair.getFirst(), (SimpleTextAttributes)pair.getSecond());
        }
    }

    private static class MyFontHelper {
        private final FontMetrics myFontMetrics;
        private final FontMetrics myBoldMetrics;
        private final FontMetrics myItalicsMetrics;
        private final FontMetrics myBoldItalicsMetrics;

        private MyFontHelper(JList list) {
            Font font = list.getFont();
            this.myFontMetrics = list.getFontMetrics(font);
            this.myBoldMetrics = list.getFontMetrics(font.deriveFont(1));
            this.myItalicsMetrics = list.getFontMetrics(font.deriveFont(2));
            this.myBoldItalicsMetrics = list.getFontMetrics(font.deriveFont(3));
        }

        public int getWidth(Pair<String, SimpleTextAttributes> pair) {
            SimpleTextAttributes ta = (SimpleTextAttributes)pair.getSecond();
            FontMetrics fm = this.getFontMetrics(ta);
            return fm.stringWidth((String)pair.getFirst());
        }

        public FontMetrics getFontMetrics(SimpleTextAttributes ta) {
            FontMetrics fm = (ta.getStyle() & 1) == 1 ? ((ta.getStyle() & 2) == 2 ? this.myBoldItalicsMetrics : this.myBoldMetrics) : ((ta.getStyle() & 2) == 2 ? this.myItalicsMetrics : this.myFontMetrics);
            return fm;
        }
    }

    protected static abstract class Description {
        private final List<Pair<String, SimpleTextAttributes>> myPieces;
        private final int myMiddleIdx;

        public Description(int middleIdx, List<Pair<String, SimpleTextAttributes>> pieces) {
            this.myMiddleIdx = middleIdx;
            this.myPieces = pieces;
        }

        public int getMiddleIdx() {
            return this.myMiddleIdx;
        }

        public List<Pair<String, SimpleTextAttributes>> getPieces() {
            return this.myPieces;
        }

        public abstract String getMaxString(int var1);
    }
}

