/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffFromHistoryHandler
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "<init>"));
        }
        this.myProject = project;
        this.myGit = (Git)ServiceManager.getService((Project)project, Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (previousRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        GitFileRevision rev = (GitFileRevision)revision;
        Collection<String> parents = rev.getParents();
        if (parents.size() < 2) {
            this.doShowDiff(filePath, previousRevision, revision, false);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    public void showDiffForTwo(@NotNull FilePath filePath, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForTwo"));
        }
        this.doShowDiff(filePath, revision1, revision2, true);
    }

    private void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, boolean autoSort) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "doShowDiff"));
        }
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "doShowDiff"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "doShowDiff"));
        }
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground((Project)this.myProject, (FilePath)filePath, (VcsFileRevision)revision1, (VcsFileRevision)revision2, (boolean)autoSort);
        } else if (revision2 instanceof CurrentRevision) {
            GitFileRevision left = (GitFileRevision)revision1;
            this.showDiffForDirectory(filePath, left.getHash(), null);
        } else if (revision1.equals(VcsFileRevision.NULL)) {
            GitFileRevision right = (GitFileRevision)revision2;
            this.showDiffForDirectory(filePath, null, right.getHash());
        } else {
            GitFileRevision left = (GitFileRevision)revision1;
            GitFileRevision right = (GitFileRevision)revision2;
            if (autoSort) {
                Pair pair = VcsHistoryUtil.sortRevisions((VcsFileRevision)revision1, (VcsFileRevision)revision2);
                left = (GitFileRevision)pair.first;
                right = (GitFileRevision)pair.second;
            }
            this.showDiffForDirectory(filePath, left.getHash(), right.getHash());
        }
    }

    private void showDiffForDirectory(final @NotNull FilePath path, final @Nullable String hash1, final @Nullable String hash2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForDirectory"));
        }
        GitRepository repository = this.getRepository(path);
        this.calculateDiffInBackground(repository, path, hash1, hash2, new Consumer<List<Change>>(){

            public void consume(List<Change> changes) {
                GitDiffFromHistoryHandler.this.showDirDiffDialog(path, hash1, hash2, changes);
            }
        });
    }

    @NotNull
    private GitRepository getRepository(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "getRepository"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(path);
        LOG.assertTrue(repository != null, (Object)("Repository is null for " + path));
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getRepository"));
        }
        return gitRepository;
    }

    private void calculateDiffInBackground(final @NotNull GitRepository repository, final @NotNull FilePath path, final @Nullable String hash1, final @Nullable String hash2, final Consumer<List<Change>> successHandler) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "calculateDiffInBackground"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "calculateDiffInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Comparing revisions..."){
            private List<Change> myChanges;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler$2", "run"));
                }
                try {
                    this.myChanges = hash1 != null ? new ArrayList<Change>(GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), hash1, hash2, Collections.singletonList(path))) : new ArrayList<Change>(GitChangeUtils.getRevisionChanges(repository.getProject(), repository.getRoot(), hash2, false, true, true).getChanges());
                }
                catch (VcsException e) {
                    GitDiffFromHistoryHandler.this.showError(e, "Error during requesting diff for directory");
                }
            }

            public void onSuccess() {
                successHandler.consume(this.myChanges);
            }
        }.queue();
    }

    private void showDirDiffDialog(@NotNull FilePath path, @Nullable String hash1, @Nullable String hash2, @NotNull List<Change> diff) {
        String title;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showDirDiffDialog"));
        }
        if (diff == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitDiffFromHistoryHandler", "showDirDiffDialog"));
        }
        DialogBuilder dialogBuilder = new DialogBuilder(this.myProject);
        if (hash2 != null) {
            title = hash1 != null ? String.format("Difference between %s and %s in %s", GitUtil.getShortHash(hash1), GitUtil.getShortHash(hash2), path.getName()) : String.format("Initial commit %s in %s", GitUtil.getShortHash(hash2), path.getName());
        } else {
            LOG.assertTrue(hash1 != null, (Object)("hash1 and hash2 can't both be null. Path: " + path));
            title = String.format("Difference between %s and local version in %s", GitUtil.getShortHash(hash1), path.getName());
        }
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, diff, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(diff);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.showNotModal();
    }

    private void showDiffForMergeCommit(final @NotNull AnActionEvent event, final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, @NotNull Collection<String> parents) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, new Consumer<MergeCommitPreCheckInfo>(){

            public void consume(MergeCommitPreCheckInfo info) {
                if (!info.wasFileTouched()) {
                    String message = String.format("There were no changes in %s in this merge commit, besides those which were made in both branches", filePath.getName());
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)GitDiffFromHistoryHandler.this.myProject, (String)message, (MessageType)MessageType.INFO);
                }
                GitDiffFromHistoryHandler.this.showPopup(event, rev, filePath, info.getParents());
            }
        });
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, final @NotNull Collection<String> parentHashes, final @NotNull Consumer<MergeCommitPreCheckInfo> resultHandler) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (parentHashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Loading changes...", false){
            private MergeCommitPreCheckInfo myInfo;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler$4", "run"));
                }
                try {
                    GitRepository repository = GitDiffFromHistoryHandler.this.getRepository(filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.this.wasFileTouched(repository, rev);
                    Collection parents = GitDiffFromHistoryHandler.this.findParentRevisions(repository, rev, parentHashes);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    String logMessage = "Error happened while executing git show " + rev + ":" + filePath;
                    GitDiffFromHistoryHandler.this.showError(e, logMessage);
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }
        }.queue();
    }

    @NotNull
    private Collection<GitFileRevision> findParentRevisions(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull Collection<String> parentHashes) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        if (currentRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        if (parentHashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(repository, currentRevision, parentHash));
        }
        ArrayList<GitFileRevision> arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        return arrayList;
    }

    @NotNull
    private GitFileRevision createParentRevision(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull String parentHash) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        if (currentRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        if (parentHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        FilePath currentRevisionPath = currentRevision.getPath();
        if (currentRevisionPath.isDirectory()) {
            GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
            if (gitFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
            }
            return gitFileRevision;
        }
        Collection<Change> changes = GitChangeUtils.getDiff(this.myProject, repository.getRoot(), parentHash, currentRevision.getHash(), null);
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, path, new GitRevisionNumber(parentHash));
            if (gitFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
            }
            return gitFileRevision;
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
        if (gitFileRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        return gitFileRevision;
    }

    private void showError(VcsException e, String logMessage) {
        LOG.info(logMessage, (Throwable)e);
        VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)e.getMessage(), (MessageType)MessageType.ERROR);
    }

    private void showPopup(@NotNull AnActionEvent event, @NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Choose parent to compare", parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(@NotNull ListPopup popup, @NotNull AnActionEvent event, @NotNull DataContext dataContext) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private ActionGroup createActionGroup(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        for (GitFileRevision parent : parents) {
            actions.add(this.createParentAction(rev, filePath, parent));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup((AnAction[])ArrayUtil.toObjectArray(actions, AnAction.class));
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createParentAction(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull GitFileRevision parent) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        ShowDiffWithParentAction showDiffWithParentAction = new ShowDiffWithParentAction(filePath, rev, parent);
        if (showDiffWithParentAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        return showDiffWithParentAction;
    }

    @NotNull
    private GitFileRevision makeRevisionFromHash(@NotNull FilePath filePath, @NotNull String hash) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
        if (gitFileRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        return gitFileRevision;
    }

    private boolean wasFileTouched(@NotNull GitRepository repository, @NotNull GitFileRevision rev) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "wasFileTouched"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "wasFileTouched"));
        }
        GitCommandResult result = this.myGit.show(repository, rev.getHash());
        if (result.success()) {
            return GitDiffFromHistoryHandler.isFilePresentInOutput(repository, rev.getPath(), result.getOutput());
        }
        throw new VcsException(result.getErrorOutputAsJoinedString());
    }

    private static boolean isFilePresentInOutput(@NotNull GitRepository repository, @NotNull FilePath path, @NotNull List<String> output) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        String relativePath = GitDiffFromHistoryHandler.getRelativePath(repository, path);
        for (String line : output) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull GitRepository repository, @NotNull FilePath path) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler", "getRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler", "getRelativePath"));
        }
        return FileUtil.getRelativePath((String)repository.getRoot().getPath(), (String)path.getPath(), (char)'/');
    }

    private class ShowDiffWithParentAction
    extends AnAction {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final GitFileRevision myRevision;
        @NotNull
        private final GitFileRevision myParentRevision;

        public ShowDiffWithParentAction(@NotNull FilePath filePath, @NotNull GitFileRevision rev, GitFileRevision parent) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            if (rev == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            super(GitUtil.getShortHash(parent.getHash()));
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(AnActionEvent e) {
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision, false);
        }
    }

    private static class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

