/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import git4idea.config.GitVcsPanel;
import git4idea.config.GitVcsSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcsConfigurable
implements Configurable {
    private final Project myProject;
    private final GitVcsSettings mySettings;
    private GitVcsPanel panel;

    public GitVcsConfigurable(@NotNull GitVcsSettings settings, @NotNull Project project) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitVcsConfigurable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/config/GitVcsConfigurable", "<init>"));
        }
        this.myProject = project;
        this.mySettings = settings;
    }

    @NotNull
    public String getDisplayName() {
        if ("Git" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsConfigurable", "getDisplayName"));
        }
        return "Git";
    }

    @Nullable
    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.Git";
    }

    @NotNull
    public JComponent createComponent() {
        this.panel = new GitVcsPanel(this.myProject);
        this.panel.load(this.mySettings);
        JComponent jComponent = this.panel.getPanel();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsConfigurable", "createComponent"));
        }
        return jComponent;
    }

    public boolean isModified() {
        return this.panel.isModified(this.mySettings);
    }

    public void apply() throws ConfigurationException {
        this.panel.save(this.mySettings);
    }

    public void reset() {
        this.panel.load(this.mySettings);
    }

    public void disposeUIResources() {
    }
}

