/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import git4idea.GitVcs;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableValidator
extends ExecutableValidator {
    private GitVcs myVcs;

    public GitExecutableValidator(@NotNull Project project, @Nullable GitVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitExecutableValidator", "<init>"));
        }
        super(project, GitBundle.message("git.executable.notification.title", new Object[0]), GitBundle.message("git.executable.notification.description", new Object[0]));
        this.myVcs = vcs;
    }

    protected String getCurrentExecutable() {
        return GitVcsApplicationSettings.getInstance().getPathToGit();
    }

    @NotNull
    protected Configurable getConfigurable() {
        Configurable configurable = this.myVcs.getConfigurable();
        if (configurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitExecutableValidator", "getConfigurable"));
        }
        return configurable;
    }

    public boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitExecutableValidator", "isExecutableValid"));
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            commandLine.addParameter("--version");
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(30000);
            return !result.isTimeout() && result.getExitCode() == 0 && result.getStderr().isEmpty();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void showNotificationOrThrow(VcsException e) throws VcsException {
        if (this.checkExecutableAndNotifyIfNeeded()) {
            throw e;
        }
    }
}

