/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GitSimpleHandler
extends GitTextHandler {
    private final StringBuilder myStderr;
    private final StringBuilder myStderrLine;
    private final StringBuilder myStdout;
    private final StringBuilder myStdoutLine;

    public GitSimpleHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
    }

    public GitSimpleHandler(@NotNull Project project, @NotNull VirtualFile directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/commands/GitSimpleHandler", "<init>"));
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
    }

    @Override
    protected void processTerminated(int exitCode) {
        if (this.myVcs == null) {
            return;
        }
        String stdout = this.myStdoutLine.toString();
        String stderr = this.myStderrLine.toString();
        if (!this.isStdoutSuppressed() && !StringUtil.isEmptyOrSpaces((String)stdout)) {
            this.myVcs.showMessages(stdout);
            LOG.info(stdout.trim());
            this.myStdoutLine.setLength(0);
        } else if (!this.isStderrSuppressed() && !StringUtil.isEmptyOrSpaces((String)stderr)) {
            this.myVcs.showErrorMessages(stderr);
            LOG.info(stderr.trim());
            this.myStderrLine.setLength(0);
        } else {
            LOG.debug(stderr.trim());
            OUTPUT_LOG.debug(stdout.trim());
        }
    }

    public void unsilence() {
        if (this.myVcs == null) {
            return;
        }
        this.myVcs.showCommandLine(this.printableCommandLine());
        if (this.myStderr.length() != 0) {
            this.myVcs.showErrorMessages(this.myStderr.toString());
        }
        if (this.myStdout.length() != 0) {
            this.myVcs.showMessages(this.myStdout.toString());
        }
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        boolean suppressed;
        StringBuilder lineRest;
        StringBuilder entire;
        if (ProcessOutputTypes.STDOUT == outputType) {
            entire = this.myStdout;
            lineRest = this.myStdoutLine;
            suppressed = this.isStdoutSuppressed();
        } else if (ProcessOutputTypes.STDERR == outputType) {
            entire = this.myStderr;
            lineRest = this.myStderrLine;
            suppressed = this.isStderrSuppressed();
        } else {
            return;
        }
        entire.append(text);
        if (this.myVcs == null || suppressed && !LOG.isDebugEnabled()) {
            return;
        }
        char last = lineRest.length() > 0 ? (char)lineRest.charAt(lineRest.length() - 1) : (char)'\uffffffff';
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (last == '\n' || last == '\r') {
                int savedPos = (ch == '\n' || ch == '\r') && ch != last ? i - 1 : i;
                if (last != '\r' || savedPos != i) {
                    String line;
                    if (lineRest.length() == 0) {
                        line = lineRest.append(text.substring(start, savedPos)).toString();
                        lineRest.setLength(0);
                    } else {
                        line = text.substring(start, savedPos);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)line)) {
                        if (!suppressed) {
                            LOG.info(line.trim());
                            if (ProcessOutputTypes.STDOUT == outputType) {
                                this.myVcs.showMessages(line);
                            } else if (ProcessOutputTypes.STDERR == outputType) {
                                this.myVcs.showErrorMessages(line);
                            }
                        } else {
                            LOG.debug(line.trim());
                        }
                    }
                }
                start = savedPos;
            }
            last = ch;
        }
        if (start != text.length()) {
            lineRest.append(text.substring(start));
        }
    }

    public String getStderr() {
        return this.myStderr.toString();
    }

    public String getStdout() {
        return this.myStdout.toString();
    }

    public String run() throws VcsException {
        if (this.isRemote()) {
            throw new IllegalStateException("Commands that require remote access could not be run using this method");
        }
        final VcsException[] ex = new VcsException[1];
        final String[] result = new String[1];
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                try {
                    if (exitCode == 0 || GitSimpleHandler.this.isIgnoredErrorCode(exitCode)) {
                        result[0] = GitSimpleHandler.this.getStdout();
                    } else {
                        String msg = GitSimpleHandler.this.getStderr();
                        if (msg.length() == 0) {
                            msg = GitSimpleHandler.this.getStdout();
                        }
                        if (msg.length() == 0) {
                            msg = GitBundle.message("git.error.exit", exitCode);
                        }
                        ex[0] = new VcsException(msg);
                    }
                }
                catch (Throwable t) {
                    ex[0] = new VcsException(t.toString(), t);
                }
            }

            public void startFailed(Throwable exception) {
                ex[0] = new VcsException("Process failed to start (" + GitSimpleHandler.this.myCommandLine.getCommandLineString() + "): " + exception.toString(), exception);
            }
        });
        this.runInCurrentThread(null);
        if (ex[0] != null) {
            throw new VcsException(ex[0].getMessage() + " during executing " + this.printableCommandLine(), (Throwable)ex[0]);
        }
        if (result[0] == null) {
            throw new VcsException("The git command returned null: " + this.printableCommandLine());
        }
        return result[0];
    }
}

