/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import git4idea.commands.GitLineHandlerListener;

public class GitSimpleEventDetector
implements GitLineHandlerListener {
    private final Event myEvent;
    private boolean myHappened;

    public GitSimpleEventDetector(Event event) {
        this.myEvent = event;
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        if (line.contains(this.myEvent.myDetectionString)) {
            this.myHappened = true;
        }
    }

    public void processTerminated(int exitCode) {
    }

    public void startFailed(Throwable exception) {
    }

    public boolean hasHappened() {
        return this.myHappened;
    }

    public static enum Event {
        CHERRY_PICK_CONFLICT("fter resolving the conflicts"),
        LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK("would be overwritten by merge"),
        UNMERGED_PREVENTING_CHECKOUT("you need to resolve your current index first"),
        UNMERGED_PREVENTING_MERGE("is not possible because you have unmerged files"),
        BRANCH_NOT_FULLY_MERGED("is not fully merged"),
        MERGE_CONFLICT("Automatic merge failed; fix conflicts and then commit the result"),
        MERGE_CONFLICT_ON_UNSTASH("Merge conflict"),
        ALREADY_UP_TO_DATE("Already up-to-date");

        private final String myDetectionString;

        private Event(String detectionString) {
            this.myDetectionString = detectionString;
        }
    }
}

