/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitLineHandlerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitMessageWithFilesDetector
implements GitLineHandlerListener {
    private final Event myEvent;
    private final VirtualFile myRoot;
    protected final Set<String> myAffectedFiles;
    protected boolean myMessageDetected;
    private boolean myFilesAreDisplayed;

    public GitMessageWithFilesDetector(@NotNull Event event, @NotNull VirtualFile root) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitMessageWithFilesDetector", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitMessageWithFilesDetector", "<init>"));
        }
        this.myAffectedFiles = new HashSet<String>();
        this.myEvent = event;
        this.myRoot = root;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitMessageWithFilesDetector", "onLineAvailable"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitMessageWithFilesDetector", "onLineAvailable"));
        }
        if (line.contains(this.myEvent.getMessageStartMarker())) {
            this.myMessageDetected = true;
            this.myFilesAreDisplayed = true;
        } else if (line.contains(this.myEvent.getMessageEndMarker())) {
            this.myFilesAreDisplayed = false;
        } else if (this.myFilesAreDisplayed) {
            this.myAffectedFiles.add(line.trim());
        }
    }

    public void processTerminated(int exitCode) {
    }

    public void startFailed(Throwable exception) {
    }

    public boolean wasMessageDetected() {
        return this.myMessageDetected;
    }

    @NotNull
    public Set<String> getRelativeFilePaths() {
        Set<String> set = this.myAffectedFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitMessageWithFilesDetector", "getRelativeFilePaths"));
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myAffectedFiles.size());
        for (String affectedFile : this.myAffectedFiles) {
            VirtualFile file = this.myRoot.findFileByRelativePath(FileUtil.toSystemIndependentName((String)affectedFile));
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitMessageWithFilesDetector", "getFiles"));
        }
        return arrayList;
    }

    public static class Event {
        private final String myMessageStartMarker;
        private final String myMessageEndMarker;

        Event(String messageStartMarker, String messageEndMarker) {
            this.myMessageStartMarker = messageStartMarker;
            this.myMessageEndMarker = messageEndMarker;
        }

        public String getMessageStartMarker() {
            return this.myMessageStartMarker;
        }

        public String getMessageEndMarker() {
            return this.myMessageEndMarker;
        }
    }
}

