/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.util.GitUIUtil;
import java.awt.EventQueue;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHandlerUtil {
    private static final Logger LOG = Logger.getInstance((String)GitHandlerUtil.class.getName());

    private GitHandlerUtil() {
    }

    @Nullable
    public static String doSynchronously(final GitSimpleHandler handler, String operationTitle, @NonNls String operationName) {
        handler.addListener(new GitHandlerListenerBase((GitHandler)handler, operationName){

            @Override
            protected String getErrorText() {
                String text = handler.getStderr();
                if (text.length() == 0) {
                    text = handler.getStdout();
                }
                return text;
            }
        });
        GitHandlerUtil.runHandlerSynchronously(handler, operationTitle, ProgressManager.getInstance(), true);
        if (!handler.isStarted() || handler.getExitCode() != 0) {
            return null;
        }
        return handler.getStdout();
    }

    public static int doSynchronously(GitLineHandler handler, String operationTitle, @NonNls String operationName) {
        return GitHandlerUtil.doSynchronously(handler, operationTitle, operationName, true);
    }

    public static int doSynchronously(GitLineHandler handler, String operationTitle, @NonNls String operationName, boolean showErrors) {
        return GitHandlerUtil.doSynchronously(handler, operationTitle, operationName, showErrors, true);
    }

    public static int doSynchronously(final GitLineHandler handler, final String operationTitle, final @NonNls String operationName, final boolean showErrors, final boolean setIndeterminateFlag) {
        ProgressManager manager = ProgressManager.getInstance();
        manager.run((Task)new Task.Modal(handler.project(), operationTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitHandlerUtil$2", "run"));
                }
                handler.addLineListener(new GitLineHandlerListenerProgress(indicator, handler, operationName, showErrors));
                GitHandlerUtil.runInCurrentThread(handler, indicator, setIndeterminateFlag, operationTitle);
            }
        });
        if (!handler.isStarted()) {
            return -1;
        }
        return handler.getExitCode();
    }

    private static void runHandlerSynchronously(final GitHandler handler, final String operationTitle, final ProgressManager manager, final boolean setIndeterminateFlag) {
        manager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                GitHandlerUtil.runInCurrentThread(handler, manager.getProgressIndicator(), setIndeterminateFlag, operationTitle);
            }
        }, operationTitle, false, handler.project());
    }

    public static void runInCurrentThread(final GitHandler handler, final ProgressIndicator indicator, final boolean setIndeterminateFlag, final @Nullable String operationName) {
        GitHandlerUtil.runInCurrentThread(handler, new Runnable(){

            @Override
            public void run() {
                if (indicator != null) {
                    indicator.setText(operationName == null ? GitBundle.message("git.running", handler.printableCommandLine()) : operationName);
                    indicator.setText2("");
                    if (setIndeterminateFlag) {
                        indicator.setIndeterminate(true);
                    }
                }
            }
        });
    }

    public static void runInCurrentThread(GitHandler handler, @Nullable Runnable postStartAction) {
        handler.runInCurrentThread(postStartAction);
    }

    public static Collection<VcsException> doSynchronouslyWithExceptions(GitLineHandler handler) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        return GitHandlerUtil.doSynchronouslyWithExceptions(handler, progressIndicator, null);
    }

    public static Collection<VcsException> doSynchronouslyWithExceptions(GitLineHandler handler, ProgressIndicator progressIndicator, @Nullable String operationName) {
        handler.addLineListener(new GitLineHandlerListenerProgress(progressIndicator, handler, operationName, false));
        GitHandlerUtil.runInCurrentThread(handler, progressIndicator, false, operationName);
        return handler.errors();
    }

    public static String formatOperationName(String operation, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitHandlerUtil", "formatOperationName"));
        }
        return operation + " '" + root.getName() + "'...";
    }

    protected static boolean isErrorLine(String text) {
        for (String prefix : GitImpl.ERROR_INDICATORS) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static class GitLineHandlerListenerProgress
    extends GitLineHandlerListenerBase {
        private final ProgressIndicator myProgressIndicator;

        public GitLineHandlerListenerProgress(ProgressIndicator manager, GitHandler handler, String operationName, boolean showErrors) {
            super(handler, operationName, showErrors);
            this.myProgressIndicator = manager;
        }

        @Override
        protected String getErrorText() {
            return "";
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (GitHandlerUtil.isErrorLine(line.trim())) {
                this.myHandler.addError(new VcsException(line));
            }
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText2(line);
            }
        }
    }

    private static abstract class GitLineHandlerListenerBase
    extends GitHandlerListenerBase
    implements GitLineHandlerListener {
        public GitLineHandlerListenerBase(GitHandler handler, String operationName, boolean showErrors) {
            super(handler, operationName, showErrors);
        }
    }

    private static abstract class GitHandlerListenerBase
    implements GitHandlerListener {
        protected final GitHandler myHandler;
        protected final String myOperationName;
        protected boolean myShowErrors;

        public GitHandlerListenerBase(GitHandler handler, String operationName) {
            this(handler, operationName, true);
        }

        public GitHandlerListenerBase(GitHandler handler, String operationName, boolean showErrors) {
            this.myHandler = handler;
            this.myOperationName = operationName;
            this.myShowErrors = showErrors;
        }

        public void processTerminated(int exitCode) {
            if (exitCode != 0 && !this.myHandler.isIgnoredErrorCode(exitCode)) {
                this.ensureError(exitCode);
                if (this.myShowErrors) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitUIUtil.showOperationErrors(GitHandlerListenerBase.this.myHandler.project(), GitHandlerListenerBase.this.myHandler.errors(), GitHandlerListenerBase.this.myOperationName);
                        }
                    });
                }
            }
        }

        protected void ensureError(int exitCode) {
            if (this.myHandler.errors().isEmpty()) {
                String text = this.getErrorText();
                if ((text == null || text.length() == 0) && this.myHandler.errors().isEmpty()) {
                    this.myHandler.addError(new VcsException(GitBundle.message("git.error.exit", exitCode)));
                } else {
                    this.myHandler.addError(new VcsException(text));
                }
            }
        }

        protected abstract String getErrorText();

        public void startFailed(final Throwable exception) {
            this.myHandler.addError(new VcsException("Git start failed: " + exception.getMessage(), exception));
            if (this.myShowErrors) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitUIUtil.showOperationError(GitHandlerListenerBase.this.myHandler.project(), GitHandlerListenerBase.this.myOperationName, exception.getMessage());
                    }
                });
            }
        }
    }
}

