/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final Function<GitBranch, String> BRANCH_TO_NAME = new Function<GitBranch, String>(){

        public String apply(@Nullable GitBranch input) {
            assert (input != null);
            return input.getName();
        }
    };
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getTrackInfoForBranch"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getTrackInfoForBranch"));
        }
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!trackInfo.getLocalBranch().equals(branch)) continue;
            return trackInfo;
        }
        return null;
    }

    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getCurrentBranchOrRev"));
        }
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + multiRootBranchConfig));
            String string = currentBranch;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getCurrentBranchOrRev"));
            }
            return string;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        String string = GitBranchUtil.getBranchNameOrRev(repository);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getCurrentBranchOrRev"));
        }
        return string;
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "convertBranchesToNames"));
        }
        Collection collection = Collections2.transform(branches, BRANCH_TO_NAME);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "convertBranchesToNames"));
        }
        return collection;
    }

    @Deprecated
    @Nullable
    public static GitLocalBranch getCurrentBranch(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getCurrentBranch"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getCurrentBranch"));
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository != null) {
            return repository.getCurrentBranch();
        }
        LOG.info("getCurrentBranch: Repository is null for root " + root);
        return GitBranchUtil.getCurrentBranchFromGit(project, root);
    }

    @Nullable
    private static GitLocalBranch getCurrentBranchFromGit(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getCurrentBranchFromGit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getCurrentBranchFromGit"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.REV_PARSE);
        handler.addParameters("--abbrev-ref", "HEAD");
        handler.setSilent(true);
        try {
            String name = handler.run();
            if (!name.equals("HEAD")) {
                return new GitLocalBranch(name, GitBranch.DUMMY_HASH);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.info("git rev-parse --abbrev-ref HEAD", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getTrackedRemoteName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedRemoteKey(branchName));
    }

    @Nullable
    public static String getTrackedBranchName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedBranchKey(branchName));
    }

    @NotNull
    private static String trackedBranchKey(String branchName) {
        String string = "branch." + branchName + ".merge";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "trackedBranchKey"));
        }
        return string;
    }

    @NotNull
    private static String trackedRemoteKey(String branchName) {
        String string = "branch." + branchName + ".remote";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "trackedRemoteKey"));
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static GitRemoteBranch tracked(@NotNull Project project, @NotNull VirtualFile root, @NotNull String branchName) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "tracked"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "tracked"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUtil", "tracked"));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        GitConfigUtil.getValues(project, root, null, result);
        String remoteName = result.get(GitBranchUtil.trackedRemoteKey(branchName));
        if (remoteName == null) {
            return null;
        }
        String branch = result.get(GitBranchUtil.trackedBranchKey(branchName));
        if (branch == null) {
            return null;
        }
        if (".".equals(remoteName)) {
            return new GitSvnRemoteBranch(branch, GitBranch.DUMMY_HASH);
        }
        GitRemote remote = GitBranchUtil.findRemoteByNameOrLogError(project, root, remoteName);
        if (remote == null) {
            return null;
        }
        return new GitStandardRemoteBranch(remote, branch, GitBranch.DUMMY_HASH);
    }

    @Deprecated
    @Nullable
    public static GitRemote findRemoteByNameOrLogError(@NotNull Project project, @NotNull VirtualFile root, @NotNull String remoteName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "findRemoteByNameOrLogError"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "findRemoteByNameOrLogError"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUtil", "findRemoteByNameOrLogError"));
        }
        GitRepository repository = GitUtil.getRepositoryForRootOrLogError(project, root);
        if (repository == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote with name " + remoteName);
            return null;
        }
        return remote;
    }

    @Deprecated
    @Nullable
    public static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Hash hash, @NotNull Collection<GitRemote> remotes) {
        if (fullBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "parseRemoteBranch"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "parseRemoteBranch"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUtil", "parseRemoteBranch"));
        }
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName, hash);
        }
        String remoteName = stdName.substring(0, slash);
        String branchName = stdName.substring(slash + 1);
        GitRemote remote = GitBranchUtil.findRemoteByName(remoteName, remotes);
        if (remote == null) {
            LOG.info(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, ContainerUtil.emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName, hash);
        }
        return new GitStandardRemoteBranch(remote, branchName, hash);
    }

    @Nullable
    private static GitRemote findRemoteByName(@NotNull String remoteName, @NotNull Collection<GitRemote> remotes) {
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "findRemoteByName"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "findRemoteByName"));
        }
        for (GitRemote remote : remotes) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getBranchNamesWithoutRemoteHead"));
        }
        Collection collection = Collections2.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                assert (input != null);
                return !input.equals("HEAD");
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranchNamesWithoutRemoteHead"));
        }
        return collection;
    }

    @Deprecated
    @Nullable
    public static GitLocalBranch findLocalBranchByName(@NotNull GitRepository repository, final @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "findLocalBranchByName"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "findLocalBranchByName"));
        }
        Optional optional = Iterables.tryFind(repository.getBranches().getLocalBranches(), (Predicate)new Predicate<GitLocalBranch>(){

            public boolean apply(@Nullable GitLocalBranch input) {
                assert (input != null);
                return input.getName().equals(branchName);
            }
        });
        if (optional.isPresent()) {
            return (GitLocalBranch)optional.get();
        }
        LOG.info(String.format("Couldn't find branch with name %s in %s", branchName, repository));
        return null;
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranchByName(@NotNull String remoteBranchName, final @NotNull String remoteName, @NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (remoteBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "findRemoteBranchByName"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "findRemoteBranchByName"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUtil", "findRemoteBranchByName"));
        }
        final String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        Optional optional = Iterables.tryFind(remoteBranches, (Predicate)new Predicate<GitRemoteBranch>(){

            public boolean apply(@Nullable GitRemoteBranch input) {
                assert (input != null);
                return input.getNameForRemoteOperations().equals(branchName) && input.getRemote().getName().equals(remoteName);
            }
        });
        if (optional.isPresent()) {
            return (GitRemoteBranch)optional.get();
        }
        LOG.info(String.format("Couldn't find branch with name %s", branchName));
        return null;
    }

    @NotNull
    public static String stripRefsPrefix(@NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "stripRefsPrefix"));
        }
        if (branchName.startsWith("refs/heads/")) {
            String string = branchName.substring("refs/heads/".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "stripRefsPrefix"));
            }
            return string;
        }
        if (branchName.startsWith("refs/remotes/")) {
            String string = branchName.substring("refs/remotes/".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "stripRefsPrefix"));
            }
            return string;
        }
        String string = branchName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "stripRefsPrefix"));
        }
        return string;
    }

    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getBranchNameOrRev"));
        }
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            String string = currentBranch.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranchNameOrRev"));
            }
            return string;
        }
        String currentRevision = repository.getCurrentRevision();
        String string = currentRevision != null ? currentRevision.substring(0, 7) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranchNameOrRev"));
        }
        return string;
    }

    @Nullable
    public static String getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<GitRepository> repositories, @NotNull String dialogTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getNewBranchNameFromUser"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getNewBranchNameFromUser"));
        }
        if (dialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUtil", "getNewBranchNameFromUser"));
        }
        return Messages.showInputDialog((Project)project, (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(repositories));
    }

    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        GitLocalBranch branch;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getDisplayableBranchText"));
        }
        Repository.State state = repository.getState();
        if (state == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            return currentRevision.substring(0, 7);
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        }
        String branchName = (branch = repository.getCurrentBranch()) == null ? "" : branch.getName();
        return prefix + branchName;
    }

    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getCurrentRepository"));
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        VirtualFile file = DvcsUtil.getSelectedFile((Project)project);
        VirtualFile root = GitBranchUtil.getVcsRootOrGuess(project, file);
        return (GitRepository)manager.getRepositoryForRoot(root);
    }

    @Nullable
    public static VirtualFile getVcsRootOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getVcsRootOrGuess"));
        }
        VirtualFile root = null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (file != null) {
            if (fileIndex.isInLibrarySource(file) || fileIndex.isInLibraryClasses(file)) {
                LOG.debug("File is in library sources " + file);
                root = GitBranchUtil.getVcsRootForLibraryFile(project, file);
            } else {
                LOG.debug("File is not in library sources " + file);
                root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file);
            }
        }
        return root != null ? root : GitBranchUtil.guessGitRoot(project);
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getVcsRootForLibraryFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getVcsRootForLibraryFile"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile root = vcsManager.getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file));
        if (root != null) {
            LOG.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.size() == 0) {
            LOG.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOG.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    private static VirtualFile guessGitRoot(@NotNull Project project) {
        VirtualFile recentRoot;
        String recentRootPath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "guessGitRoot"));
        }
        LOG.debug("Guessing Git root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        GitVcs gitVcs = GitVcs.getInstance(project);
        if (gitVcs == null) {
            LOG.debug("GitVcs not found.");
            return null;
        }
        VirtualFile[] gitRoots = vcsManager.getRootsUnderVcs((AbstractVcs)gitVcs);
        if (gitRoots.length == 0) {
            LOG.debug("No Git roots in the project.");
            return null;
        }
        if (gitRoots.length == 1) {
            VirtualFile onlyRoot = gitRoots[0];
            LOG.debug("Only one Git root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        if (settings != null && (recentRootPath = settings.getRecentRootPath()) != null && (recentRoot = VcsUtil.getVirtualFile((String)recentRootPath)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = gitRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        VirtualFile rootCandidate = null;
        for (VirtualFile root : gitRoots) {
            if (root.equals(projectBaseDir)) {
                return root;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            rootCandidate = root;
        }
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<GitRepository> repositories, boolean local) {
        Collection<Object> commonBranches = null;
        for (GitRepository repository : repositories) {
            Collection<Object> names;
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<Object> collection = names = local ? GitBranchUtil.convertBranchesToNames(branchesCollection.getLocalBranches()) : GitBranchUtil.getBranchNamesWithoutRemoteHead(branchesCollection.getRemoteBranches());
            if (commonBranches == null) {
                commonBranches = names;
                continue;
            }
            commonBranches = ContainerUtil.intersection(commonBranches, names);
        }
        if (commonBranches != null) {
            ArrayList<String> common = new ArrayList<String>(commonBranches);
            Collections.sort(common);
            ArrayList<String> arrayList = common;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getCommonBranches"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getCommonBranches"));
        }
        return list;
    }

    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUtil", "getBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUtil", "getBranches"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = handler.run()).trim().length() == 0) {
            List<String> list;
            try {
                String head = FileUtil.loadFile((File)new File(root.getPath(), GitRepositoryFiles.GIT_HEAD), (String)"UTF-8").trim();
                String prefix = "ref: refs/heads/";
                list = head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranches"));
                }
                return list2;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranches"));
            }
            return list;
        }
        ArrayList branches = ContainerUtil.newArrayList();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches.add(b);
        }
        ArrayList arrayList = branches;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUtil", "getBranches"));
        }
        return arrayList;
    }
}

