/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitCommit;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.MessageManager;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.UntrackedFilesNotifier;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myFacade = facade;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(final @NotNull String title, final @NotNull String message, final @NotNull String rollbackProposal) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder description = new StringBuilder();
                if (!StringUtil.isEmptyOrSpaces((String)message)) {
                    description.append(message).append("<br/>");
                }
                description.append(rollbackProposal);
                ok.set(0 == MessageManager.showYesNoDialog(GitBranchUiHandlerImpl.this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<GitRepository> repositories) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesNotification"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesNotification"));
        }
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params().setMergeDescription(String.format("The following files have unresolved conflicts. You need to resolve them before %s.", operationName)).setErrorNotificationTitle("Unresolved files remain.");
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitBranchUiHandlerImpl.this.myGit, GitBranchUiHandlerImpl.this.myFacade, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(final @NotNull String operationName, final @NotNull String rollbackProposal) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesMessageWithRollback"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesMessageWithRollback"));
        }
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String description = String.format("<html>You have to resolve all merge conflicts before %s.<br/>%s</html>", operationName, rollbackProposal);
                ok.set(0 == MessageManager.showYesNoDialog(GitBranchUiHandlerImpl.this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull Collection<VirtualFile> untrackedFiles) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesNotification"));
        }
        if (untrackedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesNotification"));
        }
        UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy(this.myProject, untrackedFiles, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull Collection<VirtualFile> untrackedFiles) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        if (untrackedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        String title = "Could not " + StringUtil.capitalize((String)operationName);
        String description = UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operationName, false);
        final UntrackedFilesDialog dialog = new UntrackedFilesDialog(this.myProject, untrackedFiles, StringUtil.stripHtml((String)description, (boolean)true), rollbackProposal);
        dialog.setTitle(title);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitBranchUiHandlerImpl.this.myFacade.showDialog((DialogWrapper)dialog);
            }
        });
        return dialog.isOK();
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    public int showSmartOperationDialog(@NotNull Project project, @NotNull List<Change> changes, @NotNull String operation, boolean force) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        return GitSmartOperationDialog.showAndGetAnswer(this.myProject, changes, operation, true);
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, final @NotNull Map<GitRepository, List<GitCommit>> history, final @NotNull String unmergedBranch, final @NotNull List<String> mergedToBranches, final @NotNull String baseBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (unmergedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (mergedToBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (baseBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        final AtomicBoolean forceDelete = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                forceDelete.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(GitBranchUiHandlerImpl.this.myProject, history, unmergedBranch, mergedToBranches, baseBranch));
            }
        });
        return forceDelete.get();
    }

    @NotNull
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorTitle"));
        }
        String string = "Can't " + operationName + " because of unmerged files";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorTitle"));
        }
        return string;
    }

    @NotNull
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        String string = "You have to <a href='resolve'>resolve</a> all merge conflicts before " + operationName + ".<br/>" + "After resolving conflicts you also probably would want to commit your files to the current branch.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorNotificationDescription"));
        }
        return string;
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        @NotNull
        private final String myRollbackProposal;

        public UntrackedFilesDialog(@NotNull Project project, @NotNull Collection<VirtualFile> originalFiles, @NotNull String prompt, @NotNull String rollbackProposal) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitBranchUiHandlerImpl$UntrackedFilesDialog", "<init>"));
            }
            if (originalFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitBranchUiHandlerImpl$UntrackedFilesDialog", "<init>"));
            }
            if (prompt == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitBranchUiHandlerImpl$UntrackedFilesDialog", "<init>"));
            }
            if (rollbackProposal == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/branch/GitBranchUiHandlerImpl$UntrackedFilesDialog", "<init>"));
            }
            super(project, new ArrayList<VirtualFile>(originalFiles), prompt, null, false, false, false);
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText("Rollback");
            this.setCancelButtonText("Don't rollback");
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            panel.add(buttons);
            return panel;
        }
    }
}

