/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, ui).hasHighlightingOrInProgress();
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        final VcsLogDataProvider dataProvider = (VcsLogDataProvider)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || ui == null || dataProvider == null) {
            return;
        }
        final DeepComparator dc = DeepComparator.getInstance(project, ui);
        if (selected) {
            VcsLogBranchFilter branchFilter = ui.getFilterUi().getFilters().getBranchFilter();
            if (branchFilter == null || branchFilter.getBranchNames().size() != 1) {
                DeepCompareAction.selectBranchAndPerformAction(ui.getDataPack(), e, new Consumer<String>(){

                    public void consume(String selectedBranch) {
                        ui.getFilterUi().setFilter((VcsLogFilter)new VcsLogBranchFilterImpl(Collections.singleton(selectedBranch)));
                        dc.highlightInBackground(selectedBranch, dataProvider);
                    }
                });
                return;
            }
            String branchToCompare = (String)branchFilter.getBranchNames().iterator().next();
            dc.highlightInBackground(branchToCompare, dataProvider);
        } else {
            dc.stopAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogDataPack dataPack, @NotNull AnActionEvent event, final @NotNull Consumer<String> consumer) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        ActionGroup actionGroup = BranchFilterPopupComponent.constructActionGroup((VcsLogDataPack)dataPack, null, (Function)new Function<String, AnAction>(){

            public AnAction fun(final String s) {
                return new DumbAwareAction(s){

                    public void actionPerformed(AnActionEvent e) {
                        consumer.consume((Object)s);
                    }
                };
            }
        });
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select branch to compare", actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup.showInBestPositionFor(event.getDataContext());
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && ui != null && DeepCompareAction.hasGitRoots(project, ui.getDataPack().getLogProviders().keySet()));
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/DeepCompareAction", "hasGitRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/DeepCompareAction", "hasGitRoots"));
        }
        final GitRepositoryManager manager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        return ContainerUtil.exists(roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile root) {
                return manager.getRepositoryForRoot(root) != null;
            }
        });
    }
}

