/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DeepComparatorHolder
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<VcsLogUi, DeepComparator> myComparators;

    private DeepComparatorHolder(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/DeepComparatorHolder", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/DeepComparatorHolder", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myComparators = ContainerUtil.newHashMap();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @NotNull
    public DeepComparator getInstance(@NotNull VcsLogUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/DeepComparatorHolder", "getInstance"));
        }
        DeepComparator comparator = this.myComparators.get(ui);
        if (comparator == null) {
            comparator = new DeepComparator(this.myProject, this.myRepositoryManager, ui, this);
            this.myComparators.put(ui, comparator);
        }
        DeepComparator deepComparator = comparator;
        if (deepComparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepComparatorHolder", "getInstance"));
        }
        return deepComparator;
    }

    public void dispose() {
        this.myComparators.clear();
    }
}

