/*
 * Decompiled with CFR 0.152.
 */
package git4idea.attributes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.attributes.GitAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCheckAttrParser {
    private static final Logger LOG = Logger.getInstance(GitCheckAttrParser.class);
    private static final String UNSPECIFIED_VALUE = "unspecified";
    @NotNull
    private final Map<String, Collection<GitAttribute>> myAttributes;

    private GitCheckAttrParser(@NotNull List<String> output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/attributes/GitCheckAttrParser", "<init>"));
        }
        this.myAttributes = new HashMap<String, Collection<GitAttribute>>();
        for (String line : output) {
            if (line.isEmpty()) continue;
            List split = StringUtil.split((String)line, (String)":");
            LOG.assertTrue(split.size() == 3, (Object)String.format("Output doesn't match the expected format. Line: %s%nAll output:%n%s", line, StringUtil.join(output, (String)"\n")));
            String file = ((String)split.get(0)).trim();
            String attribute = ((String)split.get(1)).trim();
            String info = ((String)split.get(2)).trim();
            GitAttribute attr = GitAttribute.forName(attribute);
            if (attr == null || info.equalsIgnoreCase(UNSPECIFIED_VALUE)) continue;
            if (this.myAttributes.get(file) == null) {
                this.myAttributes.put(file, new ArrayList());
            }
            this.myAttributes.get(file).add(attr);
        }
    }

    @NotNull
    public static GitCheckAttrParser parse(@NotNull List<String> output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/attributes/GitCheckAttrParser", "parse"));
        }
        GitCheckAttrParser gitCheckAttrParser = new GitCheckAttrParser(output);
        if (gitCheckAttrParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/attributes/GitCheckAttrParser", "parse"));
        }
        return gitCheckAttrParser;
    }

    @NotNull
    public Map<String, Collection<GitAttribute>> getAttributes() {
        Map<String, Collection<GitAttribute>> map = this.myAttributes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/attributes/GitCheckAttrParser", "getAttributes"));
        }
        return map;
    }
}

