/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitStash
extends GitRepositoryAction {
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitStash", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitStash", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitStash", "perform"));
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification("Can not stash changes now")) {
            return;
        }
        GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        d.show();
        if (!d.isOK()) {
            return;
        }
        VirtualFile root = d.getGitRoot();
        affectedRoots.add(root);
        GitLineHandler h = d.handler();
        GitHandlerUtil.doSynchronously(h, GitBundle.getString("stashing.title"), h.printableCommandLine());
        ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).hardRefresh(root);
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("stash.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitStash", "getActionName"));
        }
        return string;
    }
}

