/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRevert
extends BasicAction {
    @Override
    public boolean perform(@NotNull Project project, GitVcs vcs, @NotNull List<VcsException> exceptions, @NotNull VirtualFile[] affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitRevert", "perform"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitRevert", "perform"));
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/actions/GitRevert", "perform"));
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification("Can not revert now")) {
            return true;
        }
        ArrayList<Change> changes = new ArrayList<Change>(affectedFiles.length);
        for (VirtualFile f : affectedFiles) {
            Change ch = changeListManager.getChange(f);
            if (ch == null) continue;
            changes.add(ch);
        }
        RollbackChangesDialog.rollbackChanges((Project)project, changes);
        for (GitRepository repository : GitUtil.getRepositoriesForFiles(project, Arrays.asList(affectedFiles))) {
            repository.update();
        }
        return false;
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = UIUtil.removeMnemonic((String)GitBundle.getString("revert.action.name"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitRevert", "getActionName"));
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull Project project, @NotNull GitVcs vcs, VirtualFile ... vFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitRevert", "isEnabled"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitRevert", "isEnabled"));
        }
        if (vFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitRevert", "isEnabled"));
        }
        for (VirtualFile file : vFiles) {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (!file.isDirectory() && (fileStatus == FileStatus.NOT_CHANGED || fileStatus == FileStatus.UNKNOWN)) continue;
            return true;
        }
        return false;
    }
}

