/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.merge.GitPullDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUIUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitPull
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("pull.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitPull", "getActionName"));
        }
        return string;
    }

    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, final Set<VirtualFile> affectedRoots, final List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitPull", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitPull", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitPull", "perform"));
        }
        final GitPullDialog dialog = new GitPullDialog(project, gitRoots, defaultRoot);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        final Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before update");
        new Task.Backgroundable(project, GitBundle.message("pulling.title", dialog.getRemote()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                String url;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitPull$1", "run"));
                }
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(dialog.gitRoot());
                assert (repository != null) : "Repository can't be null for root " + dialog.gitRoot();
                String remoteOrUrl = dialog.getRemote();
                GitRemote remote = GitUtil.findRemoteByName(repository, remoteOrUrl);
                String string = url = remote == null ? remoteOrUrl : remote.getFirstUrl();
                if (url == null) {
                    return;
                }
                Git git = (Git)ServiceManager.getService(Git.class);
                GitCommandResult result = git.runRemoteCommand(new Computable<GitLineHandler>(){

                    public GitLineHandler compute() {
                        return dialog.makeHandler(url);
                    }
                });
                VirtualFile root = dialog.gitRoot();
                affectedRoots.add(root);
                String revision = repository.getCurrentRevision();
                if (revision == null) {
                    return;
                }
                GitRevisionNumber currentRev = new GitRevisionNumber(revision);
                if (result.success()) {
                    root.refresh(false, true);
                    GitMergeUtil.showUpdates(GitPull.this, project, exceptions, root, currentRev, beforeLabel, GitPull.this.getActionName(), ActionInfo.UPDATE);
                    repositoryManager.updateRepository(root);
                    GitPull.this.runFinalTasks(project, GitVcs.getInstance(project), affectedRoots, GitPull.this.getActionName(), exceptions);
                } else {
                    GitUIUtil.notifyError(project, "Error pulling " + dialog.getRemote(), result.getErrorOutputAsJoinedString(), true, null);
                    repositoryManager.updateRepository(root);
                }
            }
        }.queue();
    }

    @Override
    protected boolean executeFinalTasksSynchronously() {
        return false;
    }
}

