/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.TerminalIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalView;

public class OpenLocalTerminalAction
extends AnAction
implements DumbAware {
    public OpenLocalTerminalAction() {
        super("Open Terminal...", null, TerminalIcons.OpenTerminal);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.runLocalTerminal(e);
    }

    public void runLocalTerminal(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        OpenLocalTerminalAction.runLocalTerminal(project);
    }

    public static void runLocalTerminal(Project project) {
        ToolWindow terminal = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (terminal.isActive()) {
            TerminalView.getInstance(project).openLocalSession(project, terminal);
        }
        terminal.activate(new Runnable(){

            @Override
            public void run() {
            }
        }, true);
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        LocalTerminalDirectRunner localTerminalDirectRunner = new LocalTerminalDirectRunner(project);
        if (localTerminalDirectRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/OpenLocalTerminalAction", "createTerminalRunner"));
        }
        return localTerminalDirectRunner;
    }
}

