/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnMethodInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z1-9_\\(\\)]*)\"");

    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnMethodInspection", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @NotNull
    public String getDisplayName() {
        if ("dependsOnMethods problem" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnMethodInspection", "getDisplayName"));
        }
        return "dependsOnMethods problem";
    }

    @NotNull
    public String getShortName() {
        if ("dependsOnMethodTestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnMethodInspection", "getShortName"));
        }
        return "dependsOnMethodTestNG";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/theoryinpractice/testng/inspection/DependsOnMethodInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/theoryinpractice/testng/inspection/DependsOnMethodInspection", "checkClass"));
        }
        if (!psiClass.getContainingFile().isWritable()) {
            return null;
        }
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression initializer;
            PsiElement resolve;
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("dependsOnMethods");
            if (value == null) continue;
            String text = value.getText();
            if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static") && ((PsiField)resolve).hasModifierProperty("final") && (initializer = ((PsiField)resolve).getInitializer()) != null) {
                text = initializer.getText();
            }
            Matcher matcher = PATTERN.matcher(text);
            while (matcher.find()) {
                String methodName = matcher.group(1);
                DependsOnMethodInspection.checkMethodNameDependency(manager, psiClass, methodName, value, problemDescriptors, isOnTheFly);
            }
        }
        return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }

    private static void checkMethodNameDependency(InspectionManager manager, PsiClass psiClass, String methodName, PsiAnnotationMemberValue value, List<ProblemDescriptor> problemDescriptors, boolean onTheFly) {
        LOGGER.debug("Found dependsOnMethods with text: " + methodName);
        if (methodName.length() > 0 && methodName.charAt(methodName.length() - 1) == ')') {
            LOGGER.debug("dependsOnMethods contains ()" + psiClass.getName());
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, "Method '" + methodName + "' should not include () characters.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
            problemDescriptors.add(descriptor);
        } else {
            String configAnnotation = TestNGUtil.getConfigAnnotation((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class));
            PsiMethod[] foundMethods = psiClass.findMethodsByName(methodName, true);
            if (foundMethods.length == 0) {
                LOGGER.debug("dependsOnMethods method doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, "Method '" + methodName + "' unknown.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                problemDescriptors.add(descriptor);
            } else {
                boolean hasTestsOrConfigs = false;
                for (PsiMethod foundMethod : foundMethods) {
                    if (configAnnotation != null) {
                        hasTestsOrConfigs |= AnnotationUtil.isAnnotated((PsiModifierListOwner)foundMethod, (String)configAnnotation, (boolean)true);
                        continue;
                    }
                    hasTestsOrConfigs |= TestNGUtil.hasTest((PsiModifierListOwner)foundMethod);
                }
                if (!hasTestsOrConfigs) {
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, configAnnotation == null ? "Method '" + methodName + "' is not a test or configuration method." : "Method '" + methodName + "' is not annotated with @" + configAnnotation, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                    problemDescriptors.add(descriptor);
                }
            }
        }
    }
}

