/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.theoryinpractice.testng.inspection.TestNGSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestNGRelatedFilesProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/theoryinpractice/testng/TestNGRelatedFilesProvider", "getItems"));
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
        if (psiClass != null) {
            Project project = psiClass.getProject();
            while (psiClass != null && TestNGUtil.hasTest((PsiModifierListOwner)psiClass) && PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true)) {
                String qName = psiClass.getQualifiedName();
                if (qName != null) {
                    String[] names;
                    final String packageQName = ((PsiJavaFile)psiClass.getContainingFile()).getPackageName();
                    String packageName = StringUtil.getShortName((String)packageQName);
                    if (packageQName.length() > 0) {
                        String pName = packageName.length() > 0 ? packageName : packageQName;
                        names = new String[]{qName, pName};
                    } else {
                        names = new String[]{qName};
                    }
                    final ArrayList tags = new ArrayList();
                    for (final String name : names) {
                        PsiSearchHelper.SERVICE.getInstance((Project)project).processUsagesInNonJavaFiles(name, new PsiNonJavaFileReferenceProcessor(){

                            public boolean process(PsiFile file, int startOffset, int endOffset) {
                                PsiReference referenceAt = file.findReferenceAt(startOffset);
                                if (referenceAt != null) {
                                    if (packageQName.endsWith(name)) {
                                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), XmlTag.class);
                                        if (tag == null || !tag.getName().equals("package")) {
                                            return true;
                                        }
                                        XmlAttribute attribute = tag.getAttribute("name");
                                        if (attribute == null) {
                                            return true;
                                        }
                                        String value = attribute.getValue();
                                        if (value == null) {
                                            return true;
                                        }
                                        if (!value.equals(StringUtil.getQualifiedName((String)packageQName, (String)"*")) && !value.equals(packageQName)) {
                                            return true;
                                        }
                                    }
                                    tags.add(referenceAt.getElement());
                                }
                                return true;
                            }
                        }, (GlobalSearchScope)new TestNGSearchScope(project));
                    }
                    if (!tags.isEmpty()) {
                        List list = GotoRelatedItem.createItems(tags, (String)"TestNG");
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGRelatedFilesProvider", "getItems"));
                        }
                        return list;
                    }
                }
                psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/TestNGRelatedFilesProvider", "getItems"));
        }
        return list;
    }
}

