/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.junit3.JUnit3IdeaTestRunner;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitForkedStarter;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnitStarter {
    public static final int VERSION = 5;
    public static final String IDE_VERSION = "-ideVersion";
    public static final String JUNIT3_PARAMETER = "-junit3";
    private static final String SOCKET = "-socket";
    private static String ourForkMode;
    private static String ourCommandFileName;
    private static String ourWorkingDirs;
    public static boolean SM_RUNNER;

    public static void main(String[] args) throws IOException {
        SegmentedOutputStream out = new SegmentedOutputStream(System.out);
        SegmentedOutputStream err = new SegmentedOutputStream(System.err);
        Vector<String> argList = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            argList.addElement(arg);
        }
        ArrayList listeners = new ArrayList();
        String[] name = new String[1];
        boolean isJUnit4 = JUnitStarter.processParameters(argList, listeners, name);
        if (!JUnitStarter.canWorkWithJUnitVersion((OutputStream)err, isJUnit4)) {
            err.flush();
            System.exit(-3);
        }
        if (!JUnitStarter.checkVersion(args, err)) {
            err.flush();
            System.exit(-3);
        }
        Object[] array = new String[argList.size()];
        argList.copyInto(array);
        int exitCode = JUnitStarter.prepareStreamsAndStart((String[])array, isJUnit4, listeners, name[0], out, err);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processParameters(Vector args, List listeners, String[] params) {
        String forceJUnit3;
        String arg;
        int i;
        boolean isJunit4 = true;
        Vector<String> result = new Vector<String>(args.size());
        for (i = 0; i < args.size(); ++i) {
            arg = (String)args.get(i);
            if (arg.startsWith(IDE_VERSION)) continue;
            if (arg.equals(JUNIT3_PARAMETER)) {
                isJunit4 = false;
                continue;
            }
            if (arg.startsWith("@name")) {
                params[0] = arg.substring("@name".length());
                continue;
            }
            if (arg.startsWith("@w@")) {
                ourWorkingDirs = arg.substring(3);
                continue;
            }
            if (arg.startsWith("@@@")) {
                int pos = arg.indexOf(44);
                ourForkMode = arg.substring(3, pos);
                ourCommandFileName = arg.substring(pos + 1);
                continue;
            }
            if (arg.startsWith("@@")) {
                if (!new File(arg.substring(2)).exists()) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(arg.substring(2)));
                    while ((line = reader.readLine()) != null) {
                        listeners.add(line);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (arg.startsWith(SOCKET)) {
                int port = Integer.parseInt(arg.substring(SOCKET.length()));
                try {
                    Socket socket = new Socket(InetAddress.getByName(null), port);
                    DataInputStream os = new DataInputStream(socket.getInputStream());
                    try {
                        os.readBoolean();
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            result.addElement(arg);
        }
        args.removeAllElements();
        for (i = 0; i < result.size(); ++i) {
            arg = (String)result.get(i);
            args.addElement(arg);
        }
        if (!isJunit4) {
            try {
                Class.forName("org.junit.runner.Computer");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        if ((forceJUnit3 = System.getProperty("idea.force.junit3")) != null && Boolean.valueOf(forceJUnit3).booleanValue()) {
            return false;
        }
        try {
            Class.forName("org.junit.Test");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean checkVersion(String[] args, SegmentedOutputStream notifications) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith(IDE_VERSION)) continue;
            int ideVersion = Integer.parseInt(arg.substring(IDE_VERSION.length(), arg.length()));
            if (ideVersion != 5) {
                PrintStream stream = new PrintStream((OutputStream)notifications);
                stream.println("Wrong agent version: 5. IDE expects version: " + ideVersion);
                stream.flush();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWorkWithJUnitVersion(OutputStream notifications, boolean isJUnit4) {
        PrintStream stream = new PrintStream(notifications);
        try {
            JUnitStarter.junitVersionChecks(isJUnit4);
        }
        catch (Throwable e) {
            stream.println("!!! JUnit version 3.8 or later expected:");
            stream.println();
            e.printStackTrace(stream);
            stream.flush();
            boolean bl = false;
            return bl;
        }
        finally {
            stream.flush();
        }
        return true;
    }

    private static void junitVersionChecks(boolean isJUnit4) throws ClassNotFoundException {
        Class.forName("junit.framework.ComparisonFailure");
        JUnitStarter.getAgentClass(isJUnit4);
        new TestRunner().setPrinter((ResultPrinter)new JUnit3IdeaTestRunner.MockResultPrinter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int prepareStreamsAndStart(String[] args, boolean isJUnit4, ArrayList listeners, String name, SegmentedOutputStream out, SegmentedOutputStream err) {
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            System.setOut(new PrintStream((OutputStream)out));
            System.setErr(new PrintStream((OutputStream)err));
            if (ourCommandFileName != null && (!"none".equals(ourForkMode) || ourWorkingDirs != null && new File(ourWorkingDirs).length() > 0L)) {
                int n = JUnitForkedStarter.startForkedVMs(ourWorkingDirs, args, isJUnit4, listeners, name, out, err, ourForkMode, ourCommandFileName);
                return n;
            }
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
            testRunner.setStreams(out, err, 0);
            int n = testRunner.startRunnerWithArgs(args, listeners, name, !SM_RUNNER);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            int n = -2;
            return n;
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
    }

    static Class getAgentClass(boolean isJUnit4) throws ClassNotFoundException {
        return isJUnit4 ? Class.forName("com.intellij.junit4.JUnit4IdeaTestRunner") : Class.forName("com.intellij.junit3.JUnit3IdeaTestRunner");
    }

    static {
        SM_RUNNER = System.getProperty("idea.junit.sm_runner") != null;
    }
}

