/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview.HierarchyTreeViewController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.SplitPane;
import javax.swing.JComponent;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;

public class SceneBuilderImpl
implements SceneBuilder {
    private final URL myFileURL;
    private final EditorCallback myEditorCallback;
    private final JFXPanel myPanel = new JFXPanel();
    private EditorController myEditorController;
    private volatile boolean mySkipChanges;
    private ChangeListener<Number> myListener;
    private ChangeListener<Number> mySelectionListener;
    private final Map<String, int[][]> mySelectionState = new FixedHashMap<String, int[][]>(16);
    private static final int[] EMPTY_INTS = new int[0];

    public SceneBuilderImpl(URL url, EditorCallback editorCallback) {
        this.myFileURL = url;
        this.myEditorCallback = editorCallback;
        Platform.setImplicitExit((boolean)false);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SceneBuilderImpl.this.create();
            }
        });
    }

    private void create() {
        this.myEditorController = new EditorController();
        HierarchyTreeViewController componentTree = new HierarchyTreeViewController(this.myEditorController);
        ContentPanelController canvas = new ContentPanelController(this.myEditorController);
        InspectorPanelController propertyTable = new InspectorPanelController(this.myEditorController);
        LibraryPanelController palette = new LibraryPanelController(this.myEditorController);
        this.loadFile();
        this.startChangeListener();
        SplitPane leftPane = new SplitPane();
        leftPane.setOrientation(Orientation.VERTICAL);
        leftPane.getItems().addAll((Object[])new Node[]{palette.getPanelRoot(), componentTree.getPanelRoot()});
        leftPane.setDividerPositions(new double[]{0.5, 0.5});
        SplitPane.setResizableWithParent((Node)leftPane, (Boolean)Boolean.FALSE);
        SplitPane.setResizableWithParent((Node)propertyTable.getPanelRoot(), (Boolean)Boolean.FALSE);
        SplitPane mainPane = new SplitPane();
        mainPane.getItems().addAll((Object[])new Node[]{leftPane, canvas.getPanelRoot(), propertyTable.getPanelRoot()});
        mainPane.setDividerPositions(new double[]{0.11036789297658862, 0.8963210702341137});
        this.myPanel.setScene(new Scene((Parent)mainPane, -1.0, -1.0, true, SceneAntialiasing.BALANCED));
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void reloadFile() {
        if (this.myEditorController != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SceneBuilderImpl.this.loadFile();
                }
            });
        }
    }

    private void startChangeListener() {
        this.myListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!SceneBuilderImpl.this.mySkipChanges) {
                    SceneBuilderImpl.this.myEditorCallback.saveChanges(SceneBuilderImpl.this.myEditorController.getFxmlText());
                }
            }
        };
        this.mySelectionListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int[][] state;
                if (!SceneBuilderImpl.this.mySkipChanges && (state = SceneBuilderImpl.this.getSelectionState()) != null) {
                    SceneBuilderImpl.this.mySelectionState.put(SceneBuilderImpl.this.myEditorController.getFxmlText(), state);
                }
            }
        };
        this.myEditorController.getJobManager().revisionProperty().addListener(this.myListener);
        this.myEditorController.getSelection().revisionProperty().addListener(this.mySelectionListener);
    }

    public void close() {
        if (this.myEditorController != null) {
            this.myEditorController.getSelection().revisionProperty().removeListener(this.mySelectionListener);
            this.myEditorController.getJobManager().revisionProperty().removeListener(this.myListener);
        }
    }

    private void loadFile() {
        this.mySkipChanges = true;
        try {
            String fxmlText = FXOMDocument.readContentFromURL((URL)this.myFileURL);
            this.myEditorController.setFxmlTextAndLocation(fxmlText, this.myFileURL);
            int[][] selectionState = this.mySelectionState.get(fxmlText);
            if (selectionState != null) {
                this.restoreSelection(selectionState);
            }
        }
        catch (Throwable e) {
            this.myEditorCallback.handleError(e);
        }
        finally {
            this.mySkipChanges = false;
        }
    }

    private int[][] getSelectionState() {
        AbstractSelectionGroup group = this.myEditorController.getSelection().getGroup();
        if (group instanceof ObjectSelectionGroup) {
            Set items = ((ObjectSelectionGroup)group).getItems();
            int[][] state = new int[items.size()][];
            int index = 0;
            for (FXOMObject item : items) {
                IntArrayList path = new IntArrayList();
                SceneBuilderImpl.componentToPath(item, path);
                state[index++] = path.toArray();
            }
            return state;
        }
        return null;
    }

    private static void componentToPath(FXOMObject component, IntArrayList path) {
        FXOMObject parent = component.getParentObject();
        if (parent != null) {
            path.add(0, component.getParentProperty().getValues().indexOf(component));
            SceneBuilderImpl.componentToPath(parent, path);
        }
    }

    private void restoreSelection(int[][] state) {
        ArrayList<FXOMObject> newSelection = new ArrayList<FXOMObject>();
        FXOMObject rootComponent = this.myEditorController.getFxomDocument().getFxomRoot();
        for (int[] path : state) {
            SceneBuilderImpl.pathToComponent(newSelection, rootComponent, path, 0);
        }
        this.myEditorController.getSelection().select(newSelection);
    }

    private static void pathToComponent(Collection<FXOMObject> components, FXOMObject component, int[] path, int index) {
        if (index == path.length) {
            components.add(component);
        } else {
            int componentIndex;
            List children = Collections.emptyList();
            Map properties = ((FXOMInstance)component).getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                FXOMProperty value = (FXOMProperty)entry.getValue();
                if (!(value instanceof FXOMPropertyC)) continue;
                children = ((FXOMPropertyC)value).getValues();
                break;
            }
            if (0 <= (componentIndex = path[index]) && componentIndex < children.size()) {
                SceneBuilderImpl.pathToComponent(components, (FXOMObject)children.get(componentIndex), path, index + 1);
            }
        }
    }

    static /* synthetic */ int[] access$800() {
        return EMPTY_INTS;
    }

    private static class IntArrayList {
        private int[] myData = SceneBuilderImpl.access$800();
        private int mySize;

        private IntArrayList() {
        }

        public void add(int index, int element) {
            if (index > this.mySize || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
            }
            this.ensureCapacity(this.mySize + 1);
            System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
            this.myData[index] = element;
            ++this.mySize;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.myData.length;
            if (minCapacity > oldCapacity) {
                int[] oldData = this.myData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.myData = new int[newCapacity];
                System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
            }
        }

        public int[] toArray() {
            int[] result = new int[this.mySize];
            System.arraycopy(this.myData, 0, result, 0, this.mySize);
            return result;
        }
    }

    private static class FixedHashMap<K, V>
    extends HashMap<K, V> {
        private final int mySize;
        private final List<K> myKeys = new LinkedList<K>();

        public FixedHashMap(int size) {
            this.mySize = size;
        }

        @Override
        public V put(K key, V value) {
            if (!this.myKeys.contains(key)) {
                if (this.myKeys.size() >= this.mySize) {
                    this.remove(this.myKeys.remove(0));
                }
                this.myKeys.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public V get(Object key) {
            if (this.myKeys.contains(key)) {
                int index = this.myKeys.indexOf(key);
                int last = this.myKeys.size() - 1;
                this.myKeys.set(index, this.myKeys.get(last));
                this.myKeys.set(last, key);
            }
            return super.get(key);
        }
    }
}

