/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.mylzw;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sanselan.common.BinaryConstants;

public class MyBitOutputStream
extends OutputStream
implements BinaryConstants {
    private final OutputStream os;
    private final int byteOrder;
    private int bitsInCache = 0;
    private int bitCache = 0;
    private int bytesWritten = 0;

    public MyBitOutputStream(OutputStream os, int byteOrder) {
        this.byteOrder = byteOrder;
        this.os = os;
    }

    @Override
    public void write(int value) throws IOException {
        this.writeBits(value, 8);
    }

    public void writeBits(int value, int SampleBits) throws IOException {
        int sampleMask = (1 << SampleBits) - 1;
        value &= sampleMask;
        if (this.byteOrder == 77) {
            this.bitCache = this.bitCache << SampleBits | value;
        } else if (this.byteOrder == 73) {
            this.bitCache |= value << this.bitsInCache;
        } else {
            throw new IOException("Unknown byte order: " + this.byteOrder);
        }
        this.bitsInCache += SampleBits;
        while (this.bitsInCache >= 8) {
            int b;
            if (this.byteOrder == 77) {
                b = 0xFF & this.bitCache >> this.bitsInCache - 8;
                this.actualWrite(b);
                this.bitsInCache -= 8;
            } else if (this.byteOrder == 73) {
                b = 0xFF & this.bitCache;
                this.actualWrite(b);
                this.bitCache >>= 8;
                this.bitsInCache -= 8;
            }
            int remainderMask = (1 << this.bitsInCache) - 1;
            this.bitCache &= remainderMask;
        }
    }

    private void actualWrite(int value) throws IOException {
        this.os.write(value);
        ++this.bytesWritten;
    }

    public void flushCache() throws IOException {
        if (this.bitsInCache > 0) {
            int bitMask = (1 << this.bitsInCache) - 1;
            int b = bitMask & this.bitCache;
            if (this.byteOrder == 77) {
                this.os.write(b <<= 8 - this.bitsInCache);
            } else if (this.byteOrder == 73) {
                this.os.write(b);
            }
        }
        this.bitsInCache = 0;
        this.bitCache = 0;
    }

    public int getBytesWritten() {
        return this.bytesWritten + (this.bitsInCache > 0 ? 1 : 0);
    }
}

