/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.uiDesigner.propertyInspector.UIDesignerToolWindowManager;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class ShowHintAction
extends AnAction {
    private final QuickFixManager myManager;

    public ShowHintAction(@NotNull QuickFixManager manager, @NotNull JComponent component) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/quickFixes/ShowHintAction", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/quickFixes/ShowHintAction", "<init>"));
        }
        this.myManager = manager;
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), component);
    }

    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = this.myManager.getEditor();
        if (editor == null) {
            return;
        }
        this.myManager.showIntentionHint();
        UIDesignerToolWindowManager manager = UIDesignerToolWindowManager.getInstance(editor.getProject());
        PropertyInspector propertyInspector = manager.getPropertyInspector();
        if (propertyInspector != null && propertyInspector.isEditing()) {
            propertyInspector.stopEditing();
        }
        this.myManager.showIntentionPopup();
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null);
    }
}

