/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.ClickListener;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class LightBulbComponentImpl
extends JComponent {
    private final QuickFixManager myManager;
    private final Icon myIcon;

    public LightBulbComponentImpl(@NotNull QuickFixManager manager, @NotNull Icon icon) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/quickFixes/LightBulbComponentImpl", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/quickFixes/LightBulbComponentImpl", "<init>"));
        }
        this.myManager = manager;
        this.myIcon = icon;
        this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (acceleratorsText.length() > 0) {
            this.setToolTipText(UIDesignerBundle.message("tooltip.press.accelerator", acceleratorsText));
        }
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/quickFixes/LightBulbComponentImpl$1", "onClick"));
                }
                LightBulbComponentImpl.this.myManager.showIntentionPopup();
                return true;
            }
        }.installOn((Component)this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.myIcon.paintIcon(this, g, 0, 0);
    }
}

