/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateFieldFix
extends QuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.quickFixes.CreateFieldFix");
    private final PsiClass myClass;
    private final String myFieldClassName;
    private final String myFieldName;

    public CreateFieldFix(GuiEditor editor, @NotNull PsiClass aClass, @NotNull String fieldClass, @NotNull String fieldName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "<init>"));
        }
        if (fieldClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "<init>"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "<init>"));
        }
        super(editor, UIDesignerBundle.message("action.create.field", fieldName), null);
        this.myClass = aClass;
        this.myFieldClassName = fieldClass;
        this.myFieldName = fieldName;
    }

    public static void runImpl(final @NotNull Project project, final @NotNull RadContainer rootContainer, final @NotNull PsiClass boundClass, @NotNull String fieldClassName, final @NotNull String fieldName, final boolean showErrors, @Nullable Object undoGroupId) {
        PsiClass fieldClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "runImpl"));
        }
        if (rootContainer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "runImpl"));
        }
        if (boundClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "runImpl"));
        }
        if (fieldClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "runImpl"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/uiDesigner/quickFixes/CreateFieldFix", "runImpl"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!boundClass.isValid()) {
            return;
        }
        if (!boundClass.isWritable()) {
            if (showErrors) {
                if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)boundClass, (Project)project, (String)UIDesignerBundle.message("error.cannot.create.field", fieldClassName))) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((fieldClass = JavaPsiFacade.getInstance((Project)project).findClass(fieldClassName.replace('$', '.'), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)rootContainer.getModule()))) == null) {
            if (showErrors) {
                Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.cannot.create.field.no.class", fieldName, fieldClassName), (String)CommonBundle.getErrorTitle());
            }
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CreateFieldFix.createField(project, fieldClass, fieldName, boundClass, showErrors, rootContainer);
                    }
                });
            }
        }, UIDesignerBundle.message("command.create.field", new Object[0]), undoGroupId);
    }

    private static void createField(final Project project, PsiClass fieldClass, final String fieldName, PsiClass boundClass, boolean showErrors, IContainer rootContainer) {
        block7: {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClassType type = factory.createType(fieldClass);
            try {
                String[] modifiers;
                PsiField field = factory.createField(fieldName, (PsiType)type);
                String accessibility = GuiDesignerConfiguration.getInstance((Project)project).DEFAULT_FIELD_ACCESSIBILITY;
                PsiModifierList modifierList = field.getModifierList();
                assert (modifierList != null);
                for (String modifier : modifiers = new String[]{"private", "protected", "public"}) {
                    modifierList.setModifierProperty(modifier, accessibility.equals(modifier));
                }
                PsiField lastUiField = null;
                for (PsiField uiField : boundClass.getFields()) {
                    if (FormEditingUtil.findComponentWithBinding((IComponent)rootContainer, uiField.getName()) == null) continue;
                    lastUiField = uiField;
                }
                if (lastUiField != null) {
                    boundClass.addAfter((PsiElement)field, lastUiField);
                } else {
                    boundClass.add((PsiElement)field);
                }
            }
            catch (IncorrectOperationException exc) {
                if (!showErrors) break block7;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.cannot.create.field.reason", fieldName, exc.getMessage()), (String)CommonBundle.getErrorTitle());
                    }
                });
            }
        }
    }

    @Override
    public void run() {
        CreateFieldFix.runImpl(this.myEditor.getProject(), this.myEditor.getRootContainer(), this.myClass, this.myFieldClassName, this.myFieldName, true, null);
    }
}

