/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LayoutManagerProperty
extends Property<RadContainer, String> {
    private final PropertyRenderer<String> myRenderer = new LabelPropertyRenderer<String>(){

        @Override
        protected void customize(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/propertyInspector/properties/LayoutManagerProperty$1", "customize"));
            }
            this.setText(LayoutManagerRegistry.getLayoutManagerDisplayName(value));
        }
    };
    private final PropertyEditor<String> myEditor = new LayoutManagerEditor();

    public LayoutManagerProperty() {
        super(null, "Layout Manager");
    }

    @Override
    public String getValue(RadContainer component) {
        for (RadContainer container = component; container != null; container = container.getParent()) {
            RadLayoutManager layoutManager = container.getLayoutManager();
            if (layoutManager == null) continue;
            return layoutManager.getName();
        }
        return "GridLayoutManager";
    }

    @Override
    protected void setValueImpl(RadContainer component, String value) throws Exception {
        RadLayoutManager oldLayout = component.getLayoutManager();
        if (oldLayout != null && Comparing.equal((String)oldLayout.getName(), (String)value)) {
            return;
        }
        RadLayoutManager newLayoutManager = LayoutManagerRegistry.createLayoutManager(value);
        newLayoutManager.changeContainerLayout(component);
    }

    @Override
    @NotNull
    public PropertyRenderer<String> getRenderer() {
        PropertyRenderer<String> propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/LayoutManagerProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    @Override
    public PropertyEditor<String> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean needRefreshPropertyList() {
        return true;
    }

    private static class LayoutManagerEditor
    extends ComboBoxPropertyEditor<String> {
        public LayoutManagerEditor() {
            this.myCbx.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

                public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                    this.setText(LayoutManagerRegistry.getLayoutManagerDisplayName(value));
                }
            });
        }

        @Override
        public JComponent getComponent(RadComponent component, String value, InplaceContext inplaceContext) {
            if ("XYLayout".equals(value)) {
                this.myCbx.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getLayoutManagerNames()));
            } else {
                this.myCbx.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getNonDeprecatedLayoutManagerNames()));
            }
            this.myCbx.setSelectedItem((Object)value);
            return this.myCbx;
        }
    }
}

