/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIntProperty<T extends RadComponent>
extends Property<T, Integer> {
    private final int myDefaultValue;
    private final LabelPropertyRenderer<Integer> myRenderer;
    private final IntEditor myEditor;

    protected AbstractIntProperty(Property parent, @NotNull @NonNls String name, int defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/propertyInspector/properties/AbstractIntProperty", "<init>"));
        }
        super(parent, name);
        this.myRenderer = new LabelPropertyRenderer();
        this.myDefaultValue = defaultValue;
        this.myEditor = new IntEditor(defaultValue);
    }

    @Override
    @NotNull
    public PropertyRenderer<Integer> getRenderer() {
        LabelPropertyRenderer<Integer> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/AbstractIntProperty", "getRenderer"));
        }
        return labelPropertyRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<Integer> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isModified(T component) {
        Integer intValue = (Integer)this.getValue(component);
        return intValue != null && intValue.intValue() != this.getDefaultValue(component);
    }

    @Override
    public void resetValue(T component) throws Exception {
        this.setValue(component, this.getDefaultValue(component));
    }

    protected int getDefaultValue(T component) {
        return this.myDefaultValue;
    }
}

