/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.compiler.PsiClassWriter;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassInstrumentingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.make.BindingsCache;
import com.intellij.uiDesigner.make.FormElementNavigatable;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.CopyResourcesUtil;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class Form2ByteCodeCompiler
implements ClassInstrumentingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.make.Form2ByteCodeCompiler");

    @NotNull
    public String getDescription() {
        String string = UIDesignerBundle.message("component.gui.designer.form.to.bytecode.compiler", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    @NotNull
    public static InstrumentationClassFinder createClassFinder(@NotNull String classPath) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler", "createClassFinder"));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            try {
                urls.add(new File(s).toURI().toURL());
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        InstrumentationClassFinder instrumentationClassFinder = new InstrumentationClassFinder(urls.toArray(new URL[urls.size()]));
        if (instrumentationClassFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler", "createClassFinder"));
        }
        return instrumentationClassFinder;
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        final Project project = context.getProject();
        if (!GuiDesignerConfiguration.getInstance((Project)project).INSTRUMENT_CLASSES) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        final ArrayList items = new ArrayList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompileScope scope = context.getCompileScope();
                CompileScope projectScope = context.getProjectCompileScope();
                VirtualFile[] formFiles = projectScope.getFiles(StdFileTypes.GUI_DESIGNER_FORM, true);
                if (formFiles.length == 0) {
                    return;
                }
                CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                BindingsCache bindingsCache = new BindingsCache(project);
                HashMap module2formFiles = Form2ByteCodeCompiler.sortByModules(project, formFiles);
                try {
                    for (Module module : module2formFiles.keySet()) {
                        HashMap<String, VirtualFile> class2form = new HashMap<String, VirtualFile>();
                        ArrayList list = (ArrayList)module2formFiles.get(module);
                        for (VirtualFile formFile : list) {
                            String classToBind;
                            if (compilerManager.isExcludedFromCompilation(formFile)) continue;
                            try {
                                classToBind = bindingsCache.getBoundClassName(formFile);
                            }
                            catch (AlienFormFileException e) {
                                continue;
                            }
                            catch (Exception e) {
                                Form2ByteCodeCompiler.addMessage(context, UIDesignerBundle.message("error.cannot.process.form.file", e), formFile, CompilerMessageCategory.ERROR);
                                continue;
                            }
                            if (classToBind == null) continue;
                            VirtualFile classFile = Form2ByteCodeCompiler.findFile(context, classToBind, module);
                            if (classFile == null) {
                                if (!scope.belongs(formFile.getUrl())) continue;
                                Form2ByteCodeCompiler.addMessage(context, UIDesignerBundle.message("error.class.to.bind.does.not.exist", classToBind), formFile, CompilerMessageCategory.ERROR);
                                continue;
                            }
                            VirtualFile alreadyProcessedForm = (VirtualFile)class2form.get(classToBind);
                            if (alreadyProcessedForm != null) {
                                if (!Form2ByteCodeCompiler.belongsToCompileScope(context, formFile, classToBind)) continue;
                                Form2ByteCodeCompiler.addMessage(context, UIDesignerBundle.message("error.duplicate.bind", classToBind, alreadyProcessedForm.getPresentableUrl()), formFile, CompilerMessageCategory.ERROR);
                                continue;
                            }
                            class2form.put(classToBind, formFile);
                            MyInstrumentationItem item = new MyInstrumentationItem(classFile, formFile, classToBind);
                            items.add(item);
                        }
                    }
                }
                finally {
                    bindingsCache.close();
                }
            }
        });
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private static boolean belongsToCompileScope(CompileContext context, VirtualFile formFile, String classToBind) {
        CompileScope compileScope = context.getCompileScope();
        if (compileScope.belongs(formFile.getUrl())) {
            return true;
        }
        VirtualFile sourceFile = Form2ByteCodeCompiler.findSourceFile(context, formFile, classToBind);
        return sourceFile != null && compileScope.belongs(sourceFile.getUrl());
    }

    private static HashMap<Module, ArrayList<VirtualFile>> sortByModules(Project project, VirtualFile[] formFiles) {
        HashMap<Module, ArrayList<VirtualFile>> module2formFiles = new HashMap<Module, ArrayList<VirtualFile>>();
        for (VirtualFile formFile : formFiles) {
            Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)project);
            if (module == null) continue;
            ArrayList<Object> list = module2formFiles.get(module);
            if (list == null) {
                list = new ArrayList();
                module2formFiles.put(module, list);
            }
            list.add(formFile);
        }
        return module2formFiles;
    }

    private static HashMap<Module, ArrayList<MyInstrumentationItem>> sortByModules(Project project, FileProcessingCompiler.ProcessingItem[] items) {
        HashMap<Module, ArrayList<MyInstrumentationItem>> module2formFiles = new HashMap<Module, ArrayList<MyInstrumentationItem>>();
        for (FileProcessingCompiler.ProcessingItem item1 : items) {
            MyInstrumentationItem item = (MyInstrumentationItem)item1;
            VirtualFile formFile = item.getFormFile();
            Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)project);
            if (module == null) continue;
            ArrayList<MyInstrumentationItem> list = module2formFiles.get(module);
            if (list == null) {
                list = new ArrayList();
                module2formFiles.put(module, list);
            }
            list.add(item);
        }
        return module2formFiles;
    }

    @Nullable
    private static VirtualFile findFile(CompileContext context, String className, Module module) {
        VirtualFile file = Form2ByteCodeCompiler.findFileByRelativePath(context, module, className.replace('.', '/') + ".class");
        if (file == null) {
            file = Form2ByteCodeCompiler.findFileByRelativePath(context, module, Form2ByteCodeCompiler.getClassFileName(className.replace('$', '.'), module) + ".class");
        }
        return file;
    }

    private static VirtualFile findFileByRelativePath(CompileContext context, Module module, String relativepath) {
        VirtualFile testsOutput;
        VirtualFile file;
        VirtualFile output = context.getModuleOutputDirectory(module);
        VirtualFile virtualFile = file = output != null ? output.findFileByRelativePath(relativepath) : null;
        if (file == null && (testsOutput = context.getModuleOutputDirectoryForTests(module)) != null && !testsOutput.equals(output)) {
            file = testsOutput.findFileByRelativePath(relativepath);
        }
        return file;
    }

    private static String getClassFileName(String _className, Module module) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(_className, GlobalSearchScope.moduleScope((Module)module));
        if (aClass == null) {
            return _className.replace('.', '/');
        }
        PsiClass outerClass = aClass;
        while (outerClass.getParent() instanceof PsiClass) {
            outerClass = (PsiClass)outerClass.getParent();
        }
        String outerQualifiedName = outerClass.getQualifiedName();
        assert (outerQualifiedName != null);
        return outerQualifiedName.replace('.', '/') + _className.substring(outerQualifiedName.length()).replace('.', '$');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(final CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        ArrayList<MyInstrumentationItem> compiledItems = new ArrayList<MyInstrumentationItem>();
        context.getProgressIndicator().pushState();
        context.getProgressIndicator().setText(UIDesignerBundle.message("progress.compiling.ui.forms", new Object[0]));
        Project project = context.getProject();
        HashMap<Module, ArrayList<MyInstrumentationItem>> module2itemsList = Form2ByteCodeCompiler.sortByModules(project, items);
        ArrayList filesToRefresh = new ArrayList();
        for (Module module : module2itemsList.keySet()) {
            String classPath = OrderEnumerator.orderEntries((Module)module).recursively().getPathsList().getPathsString();
            InstrumentationClassFinder finder = Form2ByteCodeCompiler.createClassFinder(classPath);
            try {
                if (GuiDesignerConfiguration.getInstance((Project)project).COPY_FORMS_RUNTIME_TO_OUTPUT) {
                    String moduleOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
                    try {
                        String testsOutputPath;
                        if (moduleOutputPath != null) {
                            filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)moduleOutputPath, (boolean)false));
                        }
                        if ((testsOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)true)) != null && !testsOutputPath.equals(moduleOutputPath)) {
                            filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)testsOutputPath, (boolean)false));
                        }
                    }
                    catch (IOException e) {
                        Form2ByteCodeCompiler.addMessage(context, UIDesignerBundle.message("error.cannot.copy.gui.designer.form.runtime", module.getName(), e.toString()), null, CompilerMessageCategory.ERROR);
                    }
                }
                ArrayList<MyInstrumentationItem> list = module2itemsList.get(module);
                for (final MyInstrumentationItem item : list) {
                    FormErrorInfo[] warnings;
                    LwRootContainer rootContainer;
                    final VirtualFile formFile = item.getFormFile();
                    context.getProgressIndicator().setText2(formFile.getPresentableUrl());
                    String text = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            if (!Form2ByteCodeCompiler.belongsToCompileScope(context, formFile, item.getClassToBindFQname())) {
                                return null;
                            }
                            Document document = FileDocumentManager.getInstance().getDocument(formFile);
                            return document == null ? null : document.getText();
                        }
                    });
                    if (text == null) continue;
                    try {
                        rootContainer = Utils.getRootContainer((String)text, (PropertiesProvider)new CompiledClassPropertiesProvider(finder.getLoader()));
                    }
                    catch (Exception e) {
                        Form2ByteCodeCompiler.addMessage(context, UIDesignerBundle.message("error.cannot.process.form.file", e), formFile, CompilerMessageCategory.ERROR);
                        continue;
                    }
                    final File classFile = VfsUtil.virtualToIoFile((VirtualFile)item.getFile());
                    LOG.assertTrue(classFile.exists(), (Object)classFile.getPath());
                    final AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, finder, (NestedFormLoader)new PsiNestedFormLoader(module), false, (ClassWriter)new PsiClassWriter(module));
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            codeGenerator.patchFile(classFile);
                        }
                    });
                    FormErrorInfo[] errors = codeGenerator.getErrors();
                    for (FormErrorInfo warning : warnings = codeGenerator.getWarnings()) {
                        Form2ByteCodeCompiler.addMessage(context, warning, formFile, CompilerMessageCategory.WARNING);
                    }
                    for (FormErrorInfo error : errors) {
                        Form2ByteCodeCompiler.addMessage(context, error, formFile, CompilerMessageCategory.ERROR);
                    }
                    if (errors.length != 0) continue;
                    compiledItems.add(item);
                }
            }
            finally {
                finder.releaseResources();
            }
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        context.getProgressIndicator().popState();
        return compiledItems.toArray(new FileProcessingCompiler.ProcessingItem[compiledItems.size()]);
    }

    private static void addMessage(CompileContext context, String s, VirtualFile formFile, CompilerMessageCategory severity) {
        Form2ByteCodeCompiler.addMessage(context, new FormErrorInfo(null, s), formFile, severity);
    }

    private static void addMessage(CompileContext context, FormErrorInfo e, VirtualFile formFile, CompilerMessageCategory severity) {
        if (formFile != null) {
            FormElementNavigatable navigatable = new FormElementNavigatable(context.getProject(), formFile, e.getComponentId());
            context.addMessage(severity, formFile.getPresentableUrl() + ": " + e.getErrorMessage(), formFile.getUrl(), -1, -1, (Navigatable)navigatable);
        } else {
            context.addMessage(severity, e.getErrorMessage(), null, -1, -1);
        }
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return TimestampValidityState.load((DataInput)in);
    }

    public static VirtualFile findSourceFile(CompileContext context, VirtualFile formFile, String className) {
        Module module = context.getModuleByFile(formFile);
        if (module == null) {
            return null;
        }
        PsiClass aClass = FormEditingUtil.findClassToBind(module, className);
        if (aClass == null) {
            return null;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    private static final class MyInstrumentationItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myClassFile;
        private final VirtualFile myFormFile;
        private final String myClassToBindFQname;
        private final TimestampValidityState myState;

        private MyInstrumentationItem(VirtualFile classFile, VirtualFile formFile, String classToBindFQname) {
            this.myClassFile = classFile;
            this.myFormFile = formFile;
            this.myClassToBindFQname = classToBindFQname;
            this.myState = new TimestampValidityState(formFile.getTimeStamp());
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myClassFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2ByteCodeCompiler$MyInstrumentationItem", "getFile"));
            }
            return virtualFile;
        }

        public VirtualFile getFormFile() {
            return this.myFormFile;
        }

        public String getClassToBindFQname() {
            return this.myClassToBindFQname;
        }

        public ValidityState getValidityState() {
            return this.myState;
        }
    }
}

