/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManagerImpl
extends QuickFixManager<ComponentTree> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.componentTree.QuickFixManagerImpl");

    public QuickFixManagerImpl(GuiEditor editor, @NotNull ComponentTree componentTree, JViewport viewPort) {
        if (componentTree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/componentTree/QuickFixManagerImpl", "<init>"));
        }
        super(editor, componentTree, viewPort);
        ((ComponentTree)((Object)this.myComponent)).addTreeSelectionListener(new MyTreeSelectionListener());
    }

    @Override
    @NotNull
    protected ErrorInfo[] getErrorInfos() {
        RadComponent component = ((ComponentTree)((Object)this.myComponent)).getSelectedComponent();
        if (component == null) {
            if (ErrorInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/QuickFixManagerImpl", "getErrorInfos"));
            }
            return ErrorInfo.EMPTY_ARRAY;
        }
        ErrorInfo[] errorInfoArray = ErrorAnalyzer.getAllErrorsForComponent(component);
        if (errorInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/QuickFixManagerImpl", "getErrorInfos"));
        }
        return errorInfoArray;
    }

    @Override
    public Rectangle getErrorBounds() {
        TreePath selectionPath = ((ComponentTree)((Object)this.myComponent)).getSelectionPath();
        LOG.assertTrue(selectionPath != null);
        return ((ComponentTree)((Object)this.myComponent)).getPathBounds(selectionPath);
    }

    private final class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            QuickFixManagerImpl.this.hideIntentionHint();
            QuickFixManagerImpl.this.updateIntentionHintVisibility();
            ErrorInfo[] errorInfos = QuickFixManagerImpl.this.getErrorInfos();
            String text = errorInfos.length > 0 && errorInfos[0].myDescription != null ? errorInfos[0].myDescription : "";
            StatusBar.Info.set((String)text, (Project)((ComponentTree)((Object)QuickFixManagerImpl.this.myComponent)).getProject());
        }
    }
}

