/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ButtonGroupDescriptor;
import com.intellij.uiDesigner.componentTree.ButtonGroupListDescriptor;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentPtrDescriptor;
import com.intellij.uiDesigner.componentTree.RootDescriptor;
import com.intellij.uiDesigner.componentTree.SuppressionDescriptor;
import com.intellij.uiDesigner.componentTree.SuppressionGroupDescriptor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.LwInspectionSuppression;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class ComponentTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.componentTree.ComponentPtr");
    private static final Object[] ourEmptyObjectArray = new Object[0];
    private final Object myRootElement;
    private final GuiEditor myEditor;

    public ComponentTreeStructure(@NotNull GuiEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "<init>"));
        }
        this.myRootElement = new ComponentTreeStructureRoot();
        this.myEditor = editor;
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(Object element) {
        if (element == this.myRootElement) {
            RadButtonGroup[] buttonGroups;
            ArrayList<Object> elements = new ArrayList<Object>();
            RadRootContainer rootContainer = this.myEditor.getRootContainer();
            elements.add(new ComponentPtr(this.myEditor, rootContainer));
            LwInspectionSuppression[] suppressions = rootContainer.getInspectionSuppressions();
            if (suppressions.length > 0) {
                elements.add(suppressions);
            }
            if ((buttonGroups = rootContainer.getButtonGroups()).length > 0) {
                elements.add(buttonGroups);
            }
            return elements.toArray();
        }
        if (element instanceof ComponentPtr) {
            ComponentPtr ptr = (ComponentPtr)element;
            LOG.assertTrue(ptr.isValid());
            RadComponent component = ptr.getComponent();
            if (component instanceof RadContainer) {
                RadContainer container = (RadContainer)component;
                Object[] ptrs = new ComponentPtr[container.getComponentCount()];
                for (int i = 0; i < ptrs.length; ++i) {
                    ptrs[i] = new ComponentPtr(this.myEditor, container.getComponent(i));
                }
                return ptrs;
            }
            return ourEmptyObjectArray;
        }
        if (element instanceof LwInspectionSuppression[]) {
            ArrayList<LwInspectionSuppression> result = new ArrayList<LwInspectionSuppression>();
            for (LwInspectionSuppression suppression : (LwInspectionSuppression[])element) {
                if (suppression.getComponentId() != null && FormEditingUtil.findComponent(this.myEditor.getRootContainer(), suppression.getComponentId()) == null) continue;
                result.add(suppression);
            }
            return ArrayUtil.toObjectArray(result);
        }
        if (element instanceof RadButtonGroup[]) {
            return (RadButtonGroup[])element;
        }
        if (element instanceof LwInspectionSuppression || element instanceof RadButtonGroup) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    public Object getParentElement(Object element) {
        if (element instanceof ComponentTreeStructureRoot) {
            return null;
        }
        if (element instanceof LwInspectionSuppression[] || element instanceof RadButtonGroup[]) {
            return this.myRootElement;
        }
        if (element instanceof LwInspectionSuppression) {
            return this.myEditor.getRootContainer().getInspectionSuppressions();
        }
        if (element instanceof RadButtonGroup) {
            return this.myEditor.getRootContainer().getButtonGroups();
        }
        if (element instanceof ComponentPtr) {
            ComponentPtr ptr = (ComponentPtr)element;
            if (!ptr.isValid()) {
                return this.myRootElement;
            }
            RadComponent component = ptr.getComponent();
            if (component instanceof RadRootContainer) {
                return this.myRootElement;
            }
            return component.getParent() != null ? new ComponentPtr(this.myEditor, component.getParent(), false) : null;
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element == this.myRootElement) {
            RootDescriptor rootDescriptor = new RootDescriptor(parentDescriptor, this.myRootElement);
            if (rootDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return rootDescriptor;
        }
        if (element instanceof ComponentPtr) {
            ComponentPtrDescriptor componentPtrDescriptor = new ComponentPtrDescriptor(parentDescriptor, (ComponentPtr)element);
            if (componentPtrDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return componentPtrDescriptor;
        }
        if (element instanceof LwInspectionSuppression[]) {
            SuppressionGroupDescriptor suppressionGroupDescriptor = new SuppressionGroupDescriptor(parentDescriptor, (LwInspectionSuppression[])element);
            if (suppressionGroupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return suppressionGroupDescriptor;
        }
        if (element instanceof LwInspectionSuppression) {
            LwInspectionSuppression suppression = (LwInspectionSuppression)element;
            RadComponent target = (RadComponent)(suppression.getComponentId() == null ? null : FormEditingUtil.findComponent(this.myEditor.getRootContainer(), suppression.getComponentId()));
            SuppressionDescriptor suppressionDescriptor = new SuppressionDescriptor(parentDescriptor, target, suppression);
            if (suppressionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return suppressionDescriptor;
        }
        if (element instanceof RadButtonGroup[]) {
            ButtonGroupListDescriptor buttonGroupListDescriptor = new ButtonGroupListDescriptor(parentDescriptor, (RadButtonGroup[])element);
            if (buttonGroupListDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return buttonGroupListDescriptor;
        }
        if (element instanceof RadButtonGroup) {
            ButtonGroupDescriptor buttonGroupDescriptor = new ButtonGroupDescriptor(parentDescriptor, (RadButtonGroup)element);
            if (buttonGroupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/componentTree/ComponentTreeStructure", "createDescriptor"));
            }
            return buttonGroupDescriptor;
        }
        throw new IllegalArgumentException("unknown element: " + element);
    }

    public boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        return element == this.myRootElement || element == this.myEditor.getRootContainer();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    private class ComponentTreeStructureRoot {
        private ComponentTreeStructureRoot() {
        }

        public String toString() {
            return "root of component tree structure " + ((Object)((Object)ComponentTreeStructure.this)).toString();
        }
    }
}

