/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentPtrDescriptor
extends NodeDescriptor<ComponentPtr> {
    private ComponentPtr myPtr;
    private String myBinding;
    private String myTitle;

    public ComponentPtrDescriptor(@NotNull NodeDescriptor parentDescriptor, @NotNull ComponentPtr ptr) {
        if (parentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/componentTree/ComponentPtrDescriptor", "<init>"));
        }
        if (ptr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/componentTree/ComponentPtrDescriptor", "<init>"));
        }
        super(null, parentDescriptor);
        this.myPtr = ptr;
    }

    public boolean update() {
        this.myPtr.validate();
        if (!this.myPtr.isValid()) {
            this.myPtr = null;
            return true;
        }
        String oldBinding = this.myBinding;
        String oldTitle = this.myTitle;
        RadComponent component = this.myPtr.getComponent();
        if (component.getModule().isDisposed()) {
            return false;
        }
        this.myBinding = component instanceof RadRootContainer ? ((RadRootContainer)component).getClassToBind() : component.getBinding();
        this.myTitle = component.getComponentTitle();
        return !Comparing.equal((String)oldBinding, (String)this.myBinding) || !Comparing.equal((String)oldTitle, (String)this.myTitle);
    }

    @Nullable
    public RadComponent getComponent() {
        return this.myPtr != null ? this.myPtr.getComponent() : null;
    }

    public ComponentPtr getElement() {
        return this.myPtr;
    }
}

