/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFileReference
extends ReferenceInForm {
    public ResourceFileReference(PsiPlainTextFile file, TextRange range) {
        super(file, range);
    }

    @Nullable
    public PsiElement resolve() {
        Project project = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile formVirtualFile = this.myFile.getVirtualFile();
        if (formVirtualFile == null) {
            return null;
        }
        Module module = fileIndex.getModuleForFile(formVirtualFile);
        if (module == null) {
            return null;
        }
        VirtualFile formFile = ResourceFileUtil.findResourceFileInDependents((Module)module, (String)this.getRangeText());
        if (formFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(formFile);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/ResourceFileReference", "bindToElement"));
        }
        if (!(element instanceof PsiFile)) {
            throw new IncorrectOperationException();
        }
        this.updateRangeText(FormEditingUtil.buildResourceName((PsiFile)element));
        return this.myFile;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) {
        return this.handleFileRename(newElementName, "", true);
    }
}

