/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeFormComponentTypeFix
implements IntentionAction {
    private final PsiPlainTextFile myFormFile;
    private final String myFieldName;
    private final String myComponentTypeToSet;

    public ChangeFormComponentTypeFix(PsiPlainTextFile formFile, String fieldName, PsiType componentTypeToSet) {
        PsiClass psiClass;
        this.myFormFile = formFile;
        this.myFieldName = fieldName;
        this.myComponentTypeToSet = componentTypeToSet instanceof PsiClassType ? ((psiClass = ((PsiClassType)componentTypeToSet).resolve()) != null ? ClassUtil.getJVMClassName((PsiClass)psiClass) : ((PsiClassType)componentTypeToSet).rawType().getCanonicalText()) : componentTypeToSet.getCanonicalText();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"uidesigner.change.gui.component.type", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix", "invoke"));
        }
        CommandProcessor.getInstance().executeCommand(file.getProject(), new Runnable(){

            @Override
            public void run() {
                ReadonlyStatusHandler readOnlyHandler = ReadonlyStatusHandler.getInstance((Project)ChangeFormComponentTypeFix.this.myFormFile.getProject());
                ReadonlyStatusHandler.OperationStatus status = readOnlyHandler.ensureFilesWritable(new VirtualFile[]{ChangeFormComponentTypeFix.this.myFormFile.getVirtualFile()});
                if (!status.hasReadonlyFiles()) {
                    FormReferenceProvider.setGUIComponentType(ChangeFormComponentTypeFix.this.myFormFile, ChangeFormComponentTypeFix.this.myFieldName, ChangeFormComponentTypeFix.this.myComponentTypeToSet);
                }
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

