/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeBoundFieldTypeFix
implements IntentionAction {
    private final PsiField myField;
    private final PsiType myTypeToSet;

    public ChangeBoundFieldTypeFix(PsiField field, PsiType typeToSet) {
        this.myField = field;
        this.myTypeToSet = typeToSet;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"uidesigner.change.bound.field.type", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/ChangeBoundFieldTypeFix", "invoke"));
        }
        CommandProcessor.getInstance().executeCommand(this.myField.getProject(), new Runnable(){

            @Override
            public void run() {
                try {
                    PsiManager manager = ChangeBoundFieldTypeFix.this.myField.getManager();
                    ChangeBoundFieldTypeFix.this.myField.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeElement(ChangeBoundFieldTypeFix.this.myTypeToSet));
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)ChangeBoundFieldTypeFix.this.myField.getProject(), (String)QuickFixBundle.message((String)"cannot.change.field.exception", (Object[])new Object[]{ChangeBoundFieldTypeFix.this.myField.getName(), e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle());
                        }
                    });
                }
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

