/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveComponentAction
extends AbstractGuiEditorAction {
    private final int myRowDelta;
    private final int myColumnDelta;
    private final int myRowSpanDelta;
    private final int myColSpanDelta;

    public MoveComponentAction(int rowDelta, int columnDelta, int rowSpanDelta, int colSpanDelta) {
        super(true);
        this.myRowDelta = rowDelta;
        this.myColumnDelta = columnDelta;
        this.myRowSpanDelta = rowSpanDelta;
        this.myColSpanDelta = colSpanDelta;
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        if (this.myColumnDelta != 0) {
            Collections.sort(selection, new Comparator<RadComponent>(){

                @Override
                public int compare(RadComponent o1, RadComponent o2) {
                    int index1 = o1.getParent().indexOfComponent(o1);
                    int index2 = o2.getParent().indexOfComponent(o2);
                    return (index2 - index1) * MoveComponentAction.this.myColumnDelta;
                }
            });
        }
        for (RadComponent c : selection) {
            c.getParent().getLayoutManager().moveComponent(c, this.myRowDelta, this.myColumnDelta, this.myRowSpanDelta, this.myColSpanDelta);
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/actions/MoveComponentAction", "update"));
        }
        e.getPresentation().setEnabled(true);
        for (RadComponent c : selection) {
            if (c.getParent().getLayoutManager().canMoveComponent(c, this.myRowDelta, this.myColumnDelta, this.myRowSpanDelta, this.myColSpanDelta)) continue;
            e.getPresentation().setEnabled(false);
            return;
        }
    }
}

