/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisRepository;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantisTask
extends Task {
    private final String myId;
    private final String mySummary;
    private final Date myUpdated;
    private final boolean myClosed;
    private String myProjectName;
    private MantisRepository myRepository;

    public MantisTask(String id, String summary, MantisProject project, MantisRepository repository, Date updated, boolean closed) {
        this.myId = id;
        this.mySummary = summary;
        this.myUpdated = updated;
        this.myClosed = closed;
        this.myProjectName = !MantisProject.ALL_PROJECTS.equals(project) ? project.getName() : null;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.mySummary;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Comment[] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getComments"));
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Mantis;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Nullable
    public Date getCreated() {
        return null;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        return this.myRepository.getUrl() + "/view.php?id=" + this.getId();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @Nullable
    public String getProject() {
        return this.myProjectName;
    }

    @NotNull
    public String getNumber() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisTask", "getNumber"));
        }
        return string;
    }
}

