/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.UriUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class MantisRepositoryEditor
extends BaseRepositoryEditor<MantisRepository> {
    private ComboBox myProjectCombobox;
    private ComboBox myFilterCombobox;
    private JBLabel myProjectLabel;
    private JBLabel myFilterLabel;

    public MantisRepositoryEditor(Project project, MantisRepository repository, Consumer<MantisRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myTestButton.setText("Login");
    }

    public void apply() {
        if (!(((MantisRepository)this.myRepository).getUrl().equals(UriUtil.trimTrailingSlashes((String)this.myURLText.getText())) && ((MantisRepository)this.myRepository).getUsername().equals(this.myUserNameText.getText()) && ((MantisRepository)this.myRepository).getPassword().equals(this.myPasswordText.getText()))) {
            this.resetComboBoxes();
        } else {
            Object selectedProjectObject = this.myProjectCombobox.getModel().getSelectedItem();
            Object selectedFilterObject = this.myFilterCombobox.getModel().getSelectedItem();
            if (selectedProjectObject != null && selectedFilterObject != null && selectedProjectObject instanceof MantisProject && selectedFilterObject instanceof MantisFilter) {
                ((MantisRepository)this.myRepository).setProject((MantisProject)selectedProjectObject);
                ((MantisRepository)this.myRepository).setFilter((MantisFilter)selectedFilterObject);
            }
        }
        super.apply();
    }

    private void resetComboBoxes() {
        this.myProjectCombobox.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Login before"}));
        this.myFilterCombobox.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Login before"}));
        ((MantisRepository)this.myRepository).setProject(null);
        ((MantisRepository)this.myRepository).setFilter(null);
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            this.updateProjects();
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
        this.myFilterLabel.setAnchor(anchor);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectCombobox = new ComboBox(200);
        this.myProjectCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MantisRepositoryEditor.this.updateFilters();
            }
        });
        this.installListener((JComboBox)this.myProjectCombobox);
        this.myFilterLabel = new JBLabel("Filter:", 4);
        this.myFilterCombobox = new ComboBox(200);
        this.installListener((JComboBox)this.myFilterCombobox);
        this.updateProjects();
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, (JComponent)this.myProjectCombobox).addLabeledComponent((JComponent)this.myFilterLabel, (JComponent)this.myFilterCombobox).getPanel();
    }

    private void updateProjects() {
        try {
            this.myProjectCombobox.setModel(new DefaultComboBoxModel<Object>(((MantisRepository)this.myRepository).getProjects().toArray()));
            if (((MantisRepository)this.myRepository).getProject() != null) {
                this.myProjectCombobox.setSelectedItem((Object)((MantisRepository)this.myRepository).getProject());
            }
            this.updateFilters();
        }
        catch (Exception e) {
            this.resetComboBoxes();
        }
    }

    private void updateFilters() {
        try {
            Object selectedItem = this.myProjectCombobox.getModel().getSelectedItem();
            if (selectedItem != null && selectedItem instanceof MantisProject) {
                this.myFilterCombobox.setModel(new DefaultComboBoxModel<Object>(((MantisRepository)this.myRepository).getFilters((MantisProject)selectedItem).toArray()));
                if (((MantisRepository)this.myRepository).getFilter() != null) {
                    this.myFilterCombobox.setSelectedItem((Object)((MantisRepository)this.myRepository).getFilter());
                }
                this.doApply();
            }
        }
        catch (Exception e) {
            this.resetComboBoxes();
        }
    }
}

