/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisTask;
import com.intellij.tasks.mantis.model.FilterData;
import com.intellij.tasks.mantis.model.IssueData;
import com.intellij.tasks.mantis.model.IssueHeaderData;
import com.intellij.tasks.mantis.model.IssueNoteData;
import com.intellij.tasks.mantis.model.MantisConnectLocator;
import com.intellij.tasks.mantis.model.MantisConnectPortType;
import com.intellij.tasks.mantis.model.ProjectData;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import org.apache.axis.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Mantis")
public class MantisRepository
extends BaseRepositoryImpl {
    private static final String SOAP_API_LOCATION = "/api/soap/mantisconnect.php";
    private List<MantisProject> myProjects;
    private MantisProject myProject;
    private MantisFilter myFilter;

    public MantisRepository() {
    }

    public MantisRepository(TaskRepositoryType type) {
        super(type);
    }

    private MantisRepository(MantisRepository other) {
        super((BaseRepositoryImpl)other);
        this.myProject = other.getProject();
        this.myFilter = other.getFilter();
    }

    public BaseRepository clone() {
        return new MantisRepository(this);
    }

    @Nullable
    public String extractId(String taskName) {
        Matcher matcher = Pattern.compile("\\d+").matcher(taskName);
        return matcher.find() ? matcher.group() : null;
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        return this.getIssues(query, max, since, (ProgressIndicator)new EmptyProgressIndicator());
    }

    /*
     * WARNING - void declaration
     */
    public Task[] getIssues(@Nullable String query, int max, long since, @NotNull ProgressIndicator progressIndicator) throws Exception {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/tasks/mantis/MantisRepository", "getIssues"));
        }
        MantisConnectPortType soap = this.createSoap();
        List tasks = new ArrayList<Task>(max);
        int page = 1;
        int issuesOnPage = StringUtils.isEmpty((String)query) ? max : max * query.length() * 5;
        while (true) {
            void cancelled;
            cancelled.checkCanceled();
            List<Task> issuesFromPage = this.getIssues(page, issuesOnPage, soap);
            tasks.addAll(issuesFromPage);
            if (issuesFromPage.size() < issuesOnPage || tasks.size() >= max) break;
            ++page;
        }
        tasks = tasks.subList(0, Math.min(max, tasks.size()));
        return tasks.toArray(new Task[tasks.size()]);
    }

    private List<Task> getIssues(int page, int issuesOnPage, MantisConnectPortType soap) throws Exception {
        Object[] issues = MantisFilter.LAST_TASKS.equals(this.myFilter) ? soap.mc_project_get_issue_headers(this.getUsername(), this.getPassword(), BigInteger.valueOf(this.myProject.getId()), BigInteger.valueOf(page), BigInteger.valueOf(issuesOnPage)) : soap.mc_filter_get_issue_headers(this.getUsername(), this.getPassword(), BigInteger.valueOf(this.myProject.getId()), BigInteger.valueOf(this.myFilter.getId()), BigInteger.valueOf(page), BigInteger.valueOf(issuesOnPage));
        return ContainerUtil.mapNotNull((Object[])issues, (Function)new NullableFunction<IssueHeaderData, Task>(){

            public Task fun(IssueHeaderData issueData) {
                return MantisRepository.this.createIssue(issueData);
            }
        });
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        IssueData data = this.createSoap().mc_issue_get(this.getUsername(), this.getPassword(), BigInteger.valueOf(Integer.valueOf(id).intValue()));
        return data == null ? null : this.createIssue(data);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                MantisRepository.this.refreshProjectAndFiltersData();
            }

            public void cancel() {
            }
        };
    }

    @Nullable
    private Task createIssue(final IssueData data) {
        String id = String.valueOf(data.getId());
        if (id == null) {
            return null;
        }
        String summary = data.getSummary();
        if (summary == null) {
            return null;
        }
        boolean closed = data.getStatus().getId().intValue() >= 90;
        return new MantisTask(id, summary, this.myProject, this, data.getLast_updated().getTime(), closed){

            @Override
            public String getDescription() {
                return data.getDescription();
            }

            @Override
            @NotNull
            public Comment[] getComments() {
                Object[] notes = data.getNotes();
                if (notes == null) {
                    if (Comment.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository$3", "getComments"));
                    }
                    return Comment.EMPTY_ARRAY;
                }
                List comments = ContainerUtil.map((Object[])notes, (Function)new Function<IssueNoteData, Comment>(){

                    public Comment fun(final IssueNoteData data) {
                        return new Comment(){

                            public String getText() {
                                return data.getText();
                            }

                            @Nullable
                            public String getAuthor() {
                                return data.getReporter().getName();
                            }

                            @Nullable
                            public Date getDate() {
                                return data.getDate_submitted().getTime();
                            }
                        };
                    }
                });
                Comment[] commentArray = comments.toArray(new Comment[comments.size()]);
                if (commentArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisRepository$3", "getComments"));
                }
                return commentArray;
            }

            @Override
            @Nullable
            public Date getCreated() {
                return data.getDate_submitted().getTime();
            }
        };
    }

    @Nullable
    private Task createIssue(IssueHeaderData data) {
        String id = String.valueOf(data.getId());
        if (id == null) {
            return null;
        }
        String summary = data.getSummary();
        if (summary == null) {
            return null;
        }
        boolean closed = data.getStatus().intValue() >= 90;
        return new MantisTask(id, summary, this.myProject, this, data.getLast_updated().getTime(), closed);
    }

    public List<MantisProject> getProjects() throws Exception {
        if (this.myProjects == null) {
            this.refreshProjectAndFiltersData();
        }
        return this.myProjects;
    }

    public List<MantisFilter> getFilters(MantisProject project) throws Exception {
        if (this.myProjects == null) {
            this.refreshProjectAndFiltersData();
        }
        return project.getFilters();
    }

    public void refreshProjectAndFiltersData() throws Exception {
        MantisConnectPortType soap = this.createSoap();
        this.myProjects = new ArrayList<MantisProject>();
        Object[] projectDatas = soap.mc_projects_get_user_accessible(this.getUsername(), this.getPassword());
        ArrayList<MantisProject> projects = new ArrayList<MantisProject>(ContainerUtil.map((Object[])projectDatas, (Function)new Function<ProjectData, MantisProject>(){

            public MantisProject fun(ProjectData data) {
                return new MantisProject(data.getId().intValue(), data.getName());
            }
        }));
        if (MantisRepository.allProjectsAvailable(soap)) {
            projects.add(0, MantisProject.ALL_PROJECTS);
        }
        for (MantisProject project : projects) {
            Object[] filterDatas = soap.mc_filter_get(this.getUsername(), this.getPassword(), BigInteger.valueOf(project.getId()));
            ArrayList<MantisFilter> filters = new ArrayList<MantisFilter>();
            filters.add(MantisFilter.LAST_TASKS);
            filters.addAll(ContainerUtil.map((Object[])filterDatas, (Function)new Function<FilterData, MantisFilter>(){

                public MantisFilter fun(FilterData data) {
                    return new MantisFilter(data.getId().intValue(), data.getName());
                }
            }));
            project.setFilters(filters);
            this.myProjects.add(project);
        }
    }

    private static boolean allProjectsAvailable(MantisConnectPortType soap) throws RemoteException {
        String version = soap.mc_version();
        return VersionComparatorUtil.compare((String)version, (String)"1.2.9") >= 0;
    }

    private synchronized MantisConnectPortType createSoap() throws ServiceException, MalformedURLException {
        return new MantisConnectLocator().getMantisConnectPort(new URL(this.getUrl() + SOAP_API_LOCATION));
    }

    public MantisProject getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable MantisProject project) {
        this.myProject = project;
    }

    public MantisFilter getFilter() {
        return this.myFilter;
    }

    public void setFilter(@Nullable MantisFilter filter) {
        this.myFilter = filter;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Comparing.equal((Object)this.getProject(), (Object)((MantisRepository)((Object)o)).getProject()) && Comparing.equal((Object)this.getFilter(), (Object)((MantisRepository)((Object)o)).getFilter());
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF;
    }
}

