/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.httpclient;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.impl.TaskUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class ResponseUtil {
    public static final Logger LOG = Logger.getInstance(ResponseUtil.class);
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private ResponseUtil() {
    }

    public static Reader getResponseContentAsReader(HttpResponse response) throws IOException {
        Header header = response.getEntity().getContentEncoding();
        Charset charset = header == null ? DEFAULT_CHARSET : Charset.forName(header.getValue());
        return new InputStreamReader(response.getEntity().getContent(), charset);
    }

    public static String getResponseContentAsString(HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)DEFAULT_CHARSET);
    }

    public static final class GsonMultipleObjectsDeserializer<T>
    implements ResponseHandler<List<T>> {
        private final Gson myGson;
        private final TypeToken<List<T>> myTypeToken;

        public GsonMultipleObjectsDeserializer(Gson gson, TypeToken<List<T>> token) {
            this.myGson = gson;
            this.myTypeToken = token;
        }

        public List<T> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (LOG.isDebugEnabled()) {
                String content = ResponseUtil.getResponseContentAsString(response);
                TaskUtil.prettyFormatJsonToLog(LOG, content);
                return (List)this.myGson.fromJson(content, this.myTypeToken.getType());
            }
            return (List)this.myGson.fromJson(ResponseUtil.getResponseContentAsReader(response), this.myTypeToken.getType());
        }
    }

    public static final class GsonSingleObjectDeserializer<T>
    implements ResponseHandler<T> {
        private final Gson myGson;
        private final Class<T> myClass;

        public GsonSingleObjectDeserializer(Gson gson, Class<T> cls) {
            this.myGson = gson;
            this.myClass = cls;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (LOG.isDebugEnabled()) {
                String content = ResponseUtil.getResponseContentAsString(response);
                TaskUtil.prettyFormatJsonToLog(LOG, content);
                return (T)this.myGson.fromJson(content, this.myClass);
            }
            return (T)this.myGson.fromJson(ResponseUtil.getResponseContentAsReader(response), this.myClass);
        }
    }
}

