/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabRepositoryEditor
extends BaseRepositoryEditor<GitlabRepository> {
    private static final Logger LOG = Logger.getInstance(GitlabRepositoryEditor.class);
    private JBLabel myProjectLabel;
    private ComboBox myProjectComboBox;

    public GitlabRepositoryEditor(Project project, GitlabRepository repository, Consumer<GitlabRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myPasswordLabel.setText("Token:");
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
        this.myProjectComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<GitlabProject>(){

            public void customize(JList list, GitlabProject project, int index, boolean selected, boolean hasFocus) {
                this.setText(project == null ? "Set server URL and token first" : project.getName());
            }
        });
        this.myPasswordText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (GitlabRepositoryEditor.this.myPasswordText.getPassword().length != 0) {
                    new FetchProjectsTask().queue();
                }
            }
        });
        this.installListener((JComboBox)this.myProjectComboBox);
        this.myProjectComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).setCurrentProject((GitlabProject)e.getItem());
                }
            }
        });
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitlabRepositoryEditor.this.initialize();
            }
        });
    }

    private void initialize() {
        final GitlabProject currentProject = ((GitlabRepository)this.myRepository).getCurrentProject();
        if (currentProject != null && ((GitlabRepository)this.myRepository).isConfigured()) {
            new FetchProjectsTask(){

                @Override
                public void updateUI() {
                    super.updateUI();
                    for (int i = 0; i < GitlabRepositoryEditor.this.myProjectComboBox.getItemCount(); ++i) {
                        GitlabProject project = (GitlabProject)GitlabRepositoryEditor.this.myProjectComboBox.getItemAt(i);
                        if (project.getId() != currentProject.getId()) continue;
                        ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).setCurrentProject(project);
                        GitlabRepositoryEditor.this.myProjectComboBox.setSelectedItem((Object)project);
                        return;
                    }
                    ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).setCurrentProject(GitlabRepository.UNSPECIFIED_PROJECT);
                }
            }.queue();
        }
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectComboBox = new ComboBox(300);
        this.myProjectLabel.setLabelFor((Component)this.myProjectComboBox);
        return new FormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, (JComponent)this.myProjectComboBox).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        if (connectionSuccessful) {
            new FetchProjectsTask().queue();
        }
    }

    public void apply() {
        super.apply();
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
    }

    private class FetchProjectsTask
    extends Task.Modal {
        @NonNls
        public static final String TITLE = "Downloading Gitlab projects...";
        private List<GitlabProject> myProjects;

        private FetchProjectsTask() {
            super(GitlabRepositoryEditor.this.myProject, TITLE, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/gitlab/GitlabRepositoryEditor$FetchProjectsTask", "run"));
            }
            try {
                this.myProjects = ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).fetchProjects();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                GitlabRepositoryEditor.this.myProjectComboBox.removeAllItems();
            }
        }

        @Nullable
        public final Task.NotificationInfo notifyFinished() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    FetchProjectsTask.this.updateUI();
                }
            }, ModalityState.current());
            return null;
        }

        protected void updateUI() {
            if (this.myProjects != null) {
                GitlabRepositoryEditor.this.myProjectComboBox.setModel(new DefaultComboBoxModel<GitlabProject>(this.myProjects.toArray(new GitlabProject[this.myProjects.size()])));
                GitlabRepositoryEditor.this.myProjectComboBox.insertItemAt((Object)GitlabRepository.UNSPECIFIED_PROJECT, 0);
                GitlabRepositoryEditor.this.myProjectComboBox.setSelectedItem((Object)GitlabRepository.UNSPECIFIED_PROJECT);
            }
        }
    }
}

