/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskAutoCompletionListProvider
extends TextFieldWithAutoCompletionListProvider<Task> {
    private final Project myProject;

    public TaskAutoCompletionListProvider(Project project) {
        super(null);
        this.myProject = project;
    }

    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getQuickDocHotKeyAdvertisementTail"));
        }
        return "task description and comments";
    }

    @NotNull
    public List<Task> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        List<Task> list = TaskSearchSupport.getItems(TaskManager.getManager((Project)this.myProject), prefix, cached, parameters.isAutoPopup());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getItems"));
        }
        return list;
    }

    public void setItems(@Nullable Collection variants) {
    }

    public LookupElementBuilder createLookupBuilder(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "createLookupBuilder"));
        }
        LookupElementBuilder builder = super.createLookupBuilder((Object)task);
        builder = builder.withLookupString(task.getSummary());
        if (task.isClosed()) {
            builder = builder.strikeout();
        }
        return builder;
    }

    protected InsertHandler<LookupElement> createInsertHandler(final @NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "createInsertHandler"));
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                Document document = context.getEditor().getDocument();
                String s = ((TaskManagerImpl)TaskManager.getManager((Project)context.getProject())).getChangelistName(task);
                s = StringUtil.convertLineSeparators((String)s);
                document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)s);
                context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + s.length());
                TaskAutoCompletionListProvider.this.handleInsert(task);
            }
        };
    }

    protected void handleInsert(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "handleInsert"));
        }
    }

    protected Icon getIcon(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getIcon"));
        }
        return task.getIcon();
    }

    @NotNull
    protected String getLookupString(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getLookupString"));
        }
        String string = task.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getLookupString"));
        }
        return string;
    }

    protected String getTailText(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getTailText"));
        }
        return " " + task.getSummary();
    }

    protected String getTypeText(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "getTypeText"));
        }
        return null;
    }

    public int compare(@NotNull Task task1, @NotNull Task task2) {
        if (task1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "compare"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/actions/TaskAutoCompletionListProvider", "compare"));
        }
        throw new UnsupportedOperationException();
    }
}

