/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesCombobox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginRunConfigurationEditor
extends SettingsEditor<PluginRunConfiguration>
implements PanelWithAnchor {
    private final ModulesCombobox myModules = new ModulesCombobox();
    private final JBLabel myModuleLabel = new JBLabel(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.label", (Object[])new Object[0]));
    private final LabeledComponent<RawCommandLineEditor> myVMParameters = new LabeledComponent();
    private final LabeledComponent<RawCommandLineEditor> myProgramParameters = new LabeledComponent();
    private JComponent anchor;
    private AlternativeJREPanel myAlternativeJREPanel = new AlternativeJREPanel();
    @NonNls
    private final JCheckBox myShowLogs = new JCheckBox(DevKitBundle.message("show.smth", "idea.log"));
    private final PluginRunConfiguration myPRC;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.run.PluginRunConfigurationEditor");

    public PluginRunConfigurationEditor(final PluginRunConfiguration prc) {
        this.myPRC = prc;
        this.myShowLogs.setSelected(PluginRunConfigurationEditor.isShow(prc));
        this.myShowLogs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PluginRunConfigurationEditor.setShow(prc, PluginRunConfigurationEditor.this.myShowLogs.isSelected());
            }
        });
        this.myModules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Module selectedModule = PluginRunConfigurationEditor.this.myModules.getSelectedModule();
                if (selectedModule != null) {
                    prc.removeAllLogFiles();
                    Sdk jdk = ModuleRootManager.getInstance((Module)selectedModule).getSdk();
                    jdk = IdeaJdk.findIdeaJdk(jdk);
                    if (jdk != null) {
                        String sandboxHome = ((Sandbox)jdk.getSdkAdditionalData()).getSandboxHome();
                        if (sandboxHome == null) {
                            return;
                        }
                        try {
                            String file = new File(sandboxHome).getCanonicalPath() + File.separator + "system" + File.separator + "log" + File.separator + "idea.log";
                            if (new File(file).exists()) {
                                prc.addLogFile(file, DevKitBundle.message("idea.log.tab.title", new Object[0]), PluginRunConfigurationEditor.this.myShowLogs.isSelected());
                            }
                        }
                        catch (IOException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                }
            }
        });
        this.setAnchor((JComponent)this.myModuleLabel);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.anchor = anchor;
        this.myModuleLabel.setAnchor(anchor);
        this.myVMParameters.setAnchor(anchor);
        this.myProgramParameters.setAnchor(anchor);
    }

    private static void setShow(PluginRunConfiguration prc, boolean show) {
        ArrayList logFiles = prc.getLogFiles();
        for (LogFileOptions logFile : logFiles) {
            logFile.setEnable(show);
        }
    }

    private static boolean isShow(PluginRunConfiguration prc) {
        ArrayList logFiles = prc.getLogFiles();
        for (LogFileOptions logFile : logFiles) {
            if (!logFile.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void resetEditorFrom(PluginRunConfiguration prc) {
        this.myModules.setSelectedModule(prc.getModule());
        this.getVMParameters().setText(prc.VM_PARAMETERS);
        this.getProgramParameters().setText(prc.PROGRAM_PARAMETERS);
        this.myAlternativeJREPanel.init(prc.getAlternativeJrePath(), prc.isAlternativeJreEnabled());
    }

    public void applyEditorTo(PluginRunConfiguration prc) throws ConfigurationException {
        prc.setModule(this.myModules.getSelectedModule());
        prc.VM_PARAMETERS = this.getVMParameters().getText();
        prc.PROGRAM_PARAMETERS = this.getProgramParameters().getText();
        prc.setAlternativeJrePath(this.myAlternativeJREPanel.getPath());
        prc.setAlternativeJreEnabled(this.myAlternativeJREPanel.isPathEnabled());
    }

    @NotNull
    public JComponent createEditor() {
        this.myModules.fillModules(this.myPRC.getProject(), (ModuleType)PluginModuleType.getInstance());
        JPanel wholePanel = new JPanel(new GridBagLayout());
        this.myVMParameters.setText(DevKitBundle.message("vm.parameters", new Object[0]));
        this.myVMParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myVMParameters.getComponent()).setDialogCaption(this.myVMParameters.getRawText());
        this.myVMParameters.setLabelLocation("West");
        this.myProgramParameters.setText(DevKitBundle.message("program.parameters", new Object[0]));
        this.myProgramParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myProgramParameters.getComponent()).setDialogCaption(this.myProgramParameters.getRawText());
        this.myProgramParameters.setLabelLocation("West");
        GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 10, 4);
        wholePanel.add((Component)this.myVMParameters, gc);
        wholePanel.add((Component)this.myProgramParameters, gc);
        gc.gridwidth = 1;
        gc.gridy = 3;
        gc.weightx = 0.0;
        wholePanel.add((Component)this.myModuleLabel, gc);
        gc.weighty = 1.0;
        gc.gridx = 1;
        gc.weightx = 1.0;
        wholePanel.add((Component)this.myModules, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 2;
        wholePanel.add((Component)this.myAlternativeJREPanel, gc);
        gc.gridy = 5;
        wholePanel.add((Component)this.myShowLogs, gc);
        JPanel jPanel = wholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public RawCommandLineEditor getVMParameters() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    public RawCommandLineEditor getProgramParameters() {
        return (RawCommandLineEditor)this.myProgramParameters.getComponent();
    }
}

