/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;

public class PluginModuleBuilder
extends JavaModuleBuilder {
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";

    public ModuleType getModuleType() {
        return PluginModuleType.getInstance();
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        final String defaultPluginXMLLocation = this.getModuleFileDirectory() + '/' + META_INF + '/' + PLUGIN_XML;
        final Module module = rootModel.getModule();
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
                if (buildConfiguration != null) {
                    buildConfiguration.setPluginXmlPathAndCreateDescriptorIfDoesntExist(defaultPluginXMLLocation);
                }
            }
        });
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == IdeaJdk.getInstance();
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 0;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/module/PluginModuleBuilder", "modifyProjectTypeStep"));
        }
        return StdModuleTypes.JAVA.modifyProjectTypeStep(settingsStep, (ModuleBuilder)this);
    }
}

