/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class ConvertToGrayQuickFix
extends LocalQuickFixBase {
    private final int myNum;

    public ConvertToGrayQuickFix(int num) {
        super("Convert to Gray._" + num, "Convert to Gray");
        this.myNum = num;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToGrayQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToGrayQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression expression = factory.createExpressionFromText("com.intellij.ui.Gray._" + this.myNum, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }
}

