/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateConstructorFix;
import org.jetbrains.idea.devkit.inspections.quickfix.ImplementOrExtendFix;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class RegistrationProblemsInspection
extends DevKitInspectionBase {
    public boolean CHECK_PLUGIN_XML = true;
    public boolean CHECK_JAVA_CODE = true;
    public boolean CHECK_ACTIONS = true;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = DevKitBundle.message("inspections.registration.problems.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("ComponentRegistrationProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "getShortName"));
        }
        return "ComponentRegistrationProblems";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox checkPluginXml = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.plugin.xml", new Object[0]), this.CHECK_PLUGIN_XML);
        checkPluginXml.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RegistrationProblemsInspection.this.CHECK_PLUGIN_XML = checkPluginXml.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.java.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RegistrationProblemsInspection.this.CHECK_ACTIONS = checkJavaActions.isSelected();
            }
        });
        final JCheckBox checkJavaCode = new JCheckBox(DevKitBundle.message("inspections.registration.problems.option.check.java.code", new Object[0]), this.CHECK_JAVA_CODE);
        checkJavaCode.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                RegistrationProblemsInspection.this.CHECK_JAVA_CODE = selected = checkJavaCode.isSelected();
                checkJavaActions.setEnabled(selected);
            }
        });
        jPanel.add(checkPluginXml);
        jPanel.add(checkJavaCode);
        jPanel.add(checkJavaActions);
        return jPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "checkFile"));
        }
        if (this.CHECK_PLUGIN_XML && DescriptorUtil.isPluginXml(file)) {
            return this.checkPluginXml((XmlFile)file, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass checkedClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Set<PsiClass> componentClasses;
        if (checkedClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/RegistrationProblemsInspection", "checkClass"));
        }
        PsiIdentifier nameIdentifier = checkedClass.getNameIdentifier();
        if (this.CHECK_JAVA_CODE && nameIdentifier != null && checkedClass.getQualifiedName() != null && checkedClass.getContainingFile().getVirtualFile() != null && (componentClasses = RegistrationProblemsInspection.getRegistrationTypes(checkedClass, this.CHECK_ACTIONS)) != null) {
            List<ProblemDescriptor> problems = null;
            for (PsiClass compClass : componentClasses) {
                if (checkedClass.isInheritor(compClass, true)) continue;
                problems = this.addProblem(problems, manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.incompatible.message", compClass.isInterface() ? DevKitBundle.message("keyword.implement", new Object[0]) : DevKitBundle.message("keyword.extend", new Object[0]), compClass.getQualifiedName()), isOnTheFly, ImplementOrExtendFix.createFix(compClass, checkedClass, isOnTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
            if (ActionType.ACTION.isOfType(checkedClass) && ConstructorType.getNoArgCtor(checkedClass) == null) {
                problems = this.addProblem(problems, manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), (LocalQuickFix)new CreateConstructorFix(checkedClass, isOnTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
            if (RegistrationProblemsInspection.isAbstract((PsiModifierListOwner)checkedClass)) {
                problems = this.addProblem(problems, manager.createProblemDescriptor((PsiElement)nameIdentifier, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
            return problems != null ? problems.toArray(new ProblemDescriptor[problems.size()]) : null;
        }
        return null;
    }

    private List<ProblemDescriptor> addProblem(List<ProblemDescriptor> problems, ProblemDescriptor problemDescriptor) {
        if (problems == null) {
            problems = new SmartList();
        }
        problems.add((ProblemDescriptor)problemDescriptor);
        return problems;
    }

    @Nullable
    private ProblemDescriptor[] checkPluginXml(XmlFile xmlFile, InspectionManager manager, boolean isOnTheFly) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        RegistrationChecker checker = new RegistrationChecker(manager, xmlFile, isOnTheFly);
        DescriptorUtil.processComponents(rootTag, checker);
        DescriptorUtil.processActions(rootTag, checker);
        return checker.getProblems();
    }

    static class ConstructorType {
        static final ConstructorType DEFAULT = new ConstructorType();
        final PsiMethod myCtor;

        private ConstructorType() {
            this.myCtor = null;
        }

        protected ConstructorType(PsiMethod ctor) {
            assert (ctor != null);
            this.myCtor = ctor;
        }

        public static ConstructorType getNoArgCtor(PsiClass checkedClass) {
            PsiMethod[] constructors = checkedClass.getConstructors();
            if (constructors.length > 0) {
                for (PsiMethod ctor : constructors) {
                    if (ctor.getParameterList().getParametersCount() != 0) continue;
                    return new ConstructorType(ctor);
                }
                return null;
            }
            return DEFAULT;
        }
    }

    static class RegistrationChecker
    implements ComponentType.Processor,
    ActionType.Processor {
        private List<ProblemDescriptor> myList;
        private final InspectionManager myManager;
        private final XmlFile myXmlFile;
        private final PsiManager myPsiManager;
        private final GlobalSearchScope myScope;
        private final Set<String> myInterfaceClasses = new THashSet();
        private final boolean myOnTheFly;

        public RegistrationChecker(InspectionManager manager, XmlFile xmlFile, boolean onTheFly) {
            this.myManager = manager;
            this.myXmlFile = xmlFile;
            this.myOnTheFly = onTheFly;
            this.myPsiManager = xmlFile.getManager();
            this.myScope = xmlFile.getResolveScope();
        }

        @Override
        public boolean process(ComponentType type, XmlTag component, @Nullable XmlTagValue impl, @Nullable XmlTagValue intf) {
            if (impl == null) {
                this.addProblem((PsiElement)component, DevKitBundle.message("inspections.registration.problems.missing.implementation.class", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
            } else {
                String intfName = null;
                PsiClass intfClass = null;
                if (intf != null) {
                    intfName = intf.getTrimmedText();
                    intfClass = JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findClass(intfName, this.myScope);
                }
                String implClassName = impl.getTrimmedText();
                PsiClass implClass = JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findClass(implClassName, this.myScope);
                if (implClass == null) {
                    this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.implementation", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, implClassName, true, intfClass != null ? intfName : type.myClassName));
                } else if (DevKitInspectionBase.isAbstract((PsiModifierListOwner)implClass)) {
                    this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                }
                if (intfName != null) {
                    if (intfClass == null) {
                        this.addProblem(intf, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.interface", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, intfName, false, type.myClassName), (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix((PsiElement)this.myXmlFile, intfName, true, type.myClassName));
                    } else if (implClass != null) {
                        String fqn = intfClass.getQualifiedName();
                        if (type == ComponentType.MODULE) {
                            if (!this.checkInterface(fqn, intf)) {
                                String[] keys;
                                for (String key : keys = RegistrationChecker.makeQualifiedModuleInterfaceNames(component, fqn)) {
                                    this.checkInterface(key, intf);
                                    this.myInterfaceClasses.add(key);
                                }
                            }
                        } else {
                            this.checkInterface(fqn, intf);
                            this.myInterfaceClasses.add(fqn);
                        }
                        if (intfClass != implClass && !implClass.isInheritor(intfClass, true)) {
                            this.addProblem(impl, DevKitBundle.message("inspections.registration.problems.component.incompatible.interface", fqn), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                        }
                    }
                }
            }
            return true;
        }

        private boolean checkInterface(String fqn, XmlTagValue value) {
            if (this.myInterfaceClasses.contains(fqn)) {
                this.addProblem(value, DevKitBundle.message("inspections.registration.problems.component.duplicate.interface", fqn), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private static String[] makeQualifiedModuleInterfaceNames(XmlTag component, String fqn) {
            XmlTag[] children;
            for (XmlTag child : children = component.findSubTags("option")) {
                if (!"type".equals(child.getAttributeValue("name"))) continue;
                String value = child.getAttributeValue("value");
                SmartList names = new SmartList();
                if (value != null) {
                    String[] moduleTypes;
                    for (String moduleType : moduleTypes = value.split(";")) {
                        names.add((Object)(fqn + "#" + moduleType));
                    }
                }
                return ArrayUtil.toStringArray((Collection)names);
            }
            return new String[]{fqn};
        }

        @Override
        public boolean process(ActionType type, XmlTag action) {
            PsiElement token;
            XmlAttribute attribute = action.getAttribute("class");
            if (attribute != null && (token = DevKitInspectionBase.getAttValueToken(attribute)) != null) {
                String actionClassName = attribute.getValue().trim();
                PsiClass actionClass = ClassUtil.findPsiClass((PsiManager)this.myPsiManager, (String)actionClassName, null, (boolean)true, (GlobalSearchScope)this.myScope);
                if (actionClass == null) {
                    this.addProblem(token, DevKitBundle.message("inspections.registration.problems.cannot.resolve.class", DevKitBundle.message("class.action", new Object[0])), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.myOnTheFly, (LocalQuickFix)QuickFixFactory.getInstance().createCreateClassOrInterfaceFix(token, actionClassName, true, AnAction.class.getName()));
                } else {
                    ConstructorType noArgCtor;
                    PsiClass psiClass;
                    if (!type.isOfType(actionClass) && (psiClass = JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findClass(type.myClassName, this.myScope)) != null && !actionClass.isInheritor(psiClass, true)) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.action.incompatible.class", type.myClassName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, ImplementOrExtendFix.createFix(psiClass, actionClass, this.myOnTheFly));
                    }
                    if ((noArgCtor = ConstructorType.getNoArgCtor(actionClass)) == null) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new CreateConstructorFix(actionClass, this.myOnTheFly));
                    }
                    if (DevKitInspectionBase.isAbstract((PsiModifierListOwner)actionClass)) {
                        this.addProblem(token, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]);
                    }
                }
            }
            return true;
        }

        private void addProblem(XmlTagValue impl, String problem, ProblemHighlightType type, boolean isOnTheFly, LocalQuickFix ... fixes) {
            XmlText[] textElements;
            for (XmlText text : textElements = impl.getTextElements()) {
                if (text.getValue().trim().length() <= 0) continue;
                this.addProblem((PsiElement)text, problem, type, isOnTheFly, fixes);
            }
        }

        private void addProblem(PsiElement element, String problem, ProblemHighlightType type, boolean onTheFly, LocalQuickFix ... fixes) {
            if (this.myList == null) {
                this.myList = new SmartList();
            }
            this.myList.add(this.myManager.createProblemDescriptor(element, problem, onTheFly, fixes, type));
        }

        @Nullable
        public ProblemDescriptor[] getProblems() {
            return this.myList != null ? this.myList.toArray(new ProblemDescriptor[this.myList.size()]) : null;
        }
    }
}

